/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.apidoc.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.nuxeo.apidoc.api.BundleGroup;
import org.nuxeo.apidoc.api.BundleGroupFlatTree;
import org.nuxeo.apidoc.api.NuxeoArtifactComparator;
import org.nuxeo.apidoc.snapshot.DistributionSnapshot;

public class BundleGroupTreeHelper {
    protected final DistributionSnapshot distrib;

    public BundleGroupTreeHelper(DistributionSnapshot distrib) {
        this.distrib = distrib;
    }

    protected void browseBundleGroup(BundleGroup group, int level, List<BundleGroupFlatTree> tree) {
        BundleGroupFlatTree info = new BundleGroupFlatTree(group, level);
        tree.add(info);
        List<BundleGroup> subGroups = group.getSubGroups();
        Collections.sort(subGroups, new NuxeoArtifactComparator());
        for (BundleGroup subGroup : subGroups) {
            this.browseBundleGroup(subGroup, level + 1, tree);
        }
    }

    public List<BundleGroupFlatTree> getBundleGroupSubTree(String groupId) {
        BundleGroup group = this.distrib.getBundleGroup(groupId);
        ArrayList<BundleGroupFlatTree> tree = new ArrayList<BundleGroupFlatTree>();
        this.browseBundleGroup(group, 0, tree);
        return tree;
    }

    public List<BundleGroupFlatTree> getBundleGroupTree() {
        ArrayList<BundleGroupFlatTree> tree = new ArrayList<BundleGroupFlatTree>();
        List<BundleGroup> bgroups = this.distrib.getBundleGroups();
        Collections.sort(bgroups, new NuxeoArtifactComparator());
        for (BundleGroup group : bgroups) {
            this.browseBundleGroup(group, 0, tree);
        }
        return tree;
    }
}

