/*
 * Decompiled with CFR 0.152.
 */
package org.opentoutatice.addon.quota.check.util;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.action.search.SearchRequestBuilder;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.search.SearchType;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.metrics.sum.Sum;
import org.elasticsearch.search.aggregations.metrics.sum.SumBuilder;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.elasticsearch.api.ElasticSearchAdmin;
import org.nuxeo.elasticsearch.query.NxqlQueryConverter;
import org.nuxeo.runtime.api.Framework;

public class BlobsSizeComputer {
    private static final Log log = LogFactory.getLog(BlobsSizeComputer.class);
    protected static final String GET_DESCENDANTS_NXQL_AUTO_VERSIONING = "select ecm:uuid from Document where ((%s '%s') AND (ecm:primaryType != 'File' OR ecm:isLatestVersion = 1 ))";
    protected static final String GET_DESCENDANTS_NXQL_DEFAULT = "select ecm:uuid from Document where ((%s '%s') AND ecm:isVersion = 0)";
    protected ElasticSearchAdmin esAdmin;
    protected QueryLanguage queryLanguage = QueryLanguage.NXQL;
    private static BlobsSizeComputer instance;

    private BlobsSizeComputer() {
        this.esAdmin = (ElasticSearchAdmin)Framework.getService(ElasticSearchAdmin.class);
    }

    private BlobsSizeComputer(QueryLanguage qL) {
        this.esAdmin = (ElasticSearchAdmin)Framework.getService(ElasticSearchAdmin.class);
        this.queryLanguage = qL;
    }

    public static synchronized BlobsSizeComputer get() {
        if (instance == null) {
            instance = new BlobsSizeComputer();
        }
        return instance;
    }

    public static synchronized BlobsSizeComputer get(QueryLanguage qL) {
        if (instance == null) {
            instance = new BlobsSizeComputer(qL);
        }
        return instance;
    }

    public Long getTreeSizeFrom(CoreSession session, DocumentRef docRef) {
        Sum treeSize;
        SearchRequestBuilder request = this.esAdmin.getClient().prepareSearch(new String[]{this.esAdmin.getIndexNameForRepository(session.getRepositoryName())}).setTypes(new String[]{"doc"}).setSearchType(SearchType.QUERY_THEN_FETCH);
        TermQueryBuilder queryBuilder = null;
        switch (this.queryLanguage) {
            case NXQL: {
                String clause = 2 == docRef.type() ? " ecm:path startswith " : " ecm:ancestorId = ";
                String NXQLClause = "auto_versioning".equals("ottc.quota.computingPolicy") ? GET_DESCENDANTS_NXQL_AUTO_VERSIONING : GET_DESCENDANTS_NXQL_DEFAULT;
                queryBuilder = NxqlQueryConverter.toESQueryBuilder((String)String.format(NXQLClause, clause, docRef.toString()), (CoreSession)session);
                break;
            }
            case ES: {
                String term = 2 == docRef.type() ? " ecm:path.children " : " ecm:ancestorId ";
                queryBuilder = QueryBuilders.termQuery((String)term, (String)docRef.toString());
            }
        }
        request.setQuery(queryBuilder);
        SumBuilder aggregation = (SumBuilder)AggregationBuilders.sum((String)"tree_size").field("quota:length");
        request.addAggregation((AbstractAggregationBuilder)aggregation);
        if (log.isDebugEnabled()) {
            log.debug((Object)request.toString());
        }
        SearchResponse searchResponse = (SearchResponse)request.get();
        if (log.isDebugEnabled()) {
            log.debug((Object)searchResponse.toString());
        }
        return (treeSize = (Sum)searchResponse.getAggregations().get("tree_size")) != null ? Long.valueOf((long)treeSize.getValue()) : null;
    }

    public static enum QueryLanguage {
        NXQL,
        ES;

    }
}

