/*
 * Decompiled with CFR 0.152.
 */
package org.jmock;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsAnything;
import org.hamcrest.core.IsEqual;
import org.hamcrest.core.IsInstanceOf;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.IsNull;
import org.hamcrest.core.IsSame;
import org.jmock.Sequence;
import org.jmock.api.Action;
import org.jmock.internal.Cardinality;
import org.jmock.internal.ChangeStateSideEffect;
import org.jmock.internal.ExpectationBuilder;
import org.jmock.internal.ExpectationCollector;
import org.jmock.internal.InStateOrderingConstraint;
import org.jmock.internal.InvocationExpectationBuilder;
import org.jmock.internal.State;
import org.jmock.internal.StatePredicate;
import org.jmock.lib.action.ActionSequence;
import org.jmock.lib.action.DoAllAction;
import org.jmock.lib.action.ReturnEnumerationAction;
import org.jmock.lib.action.ReturnIteratorAction;
import org.jmock.lib.action.ReturnValueAction;
import org.jmock.lib.action.ThrowAction;
import org.jmock.syntax.ActionClause;
import org.jmock.syntax.ArgumentConstraintPhrases;
import org.jmock.syntax.CardinalityClause;
import org.jmock.syntax.MethodClause;
import org.jmock.syntax.ReceiverClause;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Duplicate member names - consider using --renamedupmembers true
 */
public class Expectations
implements ExpectationBuilder,
CardinalityClause,
ArgumentConstraintPhrases,
ActionClause {
    private List<InvocationExpectationBuilder> builders = new ArrayList<InvocationExpectationBuilder>();
    private InvocationExpectationBuilder currentBuilder = null;

    private void initialiseExpectationCapture(Cardinality cardinality) {
        this.checkLastExpectationWasFullySpecified();
        this.currentBuilder = new InvocationExpectationBuilder();
        this.currentBuilder.setCardinality(cardinality);
        this.builders.add(this.currentBuilder);
    }

    @Override
    public void buildExpectations(Action defaultAction, ExpectationCollector collector) {
        this.checkLastExpectationWasFullySpecified();
        for (InvocationExpectationBuilder builder : this.builders) {
            collector.add(builder.toExpectation(defaultAction));
        }
    }

    protected InvocationExpectationBuilder currentBuilder() {
        if (this.currentBuilder == null) {
            throw new IllegalStateException("no expectations have been specified (did you forget to to specify the cardinality of the first expectation?)");
        }
        return this.currentBuilder;
    }

    private void checkLastExpectationWasFullySpecified() {
        if (this.currentBuilder != null) {
            this.currentBuilder.checkWasFullySpecified();
        }
    }

    @Override
    public ReceiverClause exactly(int count) {
        this.initialiseExpectationCapture(Cardinality.exactly(count));
        return this.currentBuilder;
    }

    public <T> T oneOf(T mockObject) {
        return this.exactly(1).of(mockObject);
    }

    @Override
    public <T> T one(T mockObject) {
        return this.oneOf(mockObject);
    }

    @Override
    public ReceiverClause atLeast(int count) {
        this.initialiseExpectationCapture(Cardinality.atLeast(count));
        return this.currentBuilder;
    }

    @Override
    public ReceiverClause between(int minCount, int maxCount) {
        this.initialiseExpectationCapture(Cardinality.between(minCount, maxCount));
        return this.currentBuilder;
    }

    @Override
    public ReceiverClause atMost(int count) {
        this.initialiseExpectationCapture(Cardinality.atMost(count));
        return this.currentBuilder;
    }

    @Override
    public MethodClause allowing(Matcher<?> mockObjectMatcher) {
        return this.atLeast(0).of(mockObjectMatcher);
    }

    @Override
    public <T> T allowing(T mockObject) {
        return this.atLeast(0).of(mockObject);
    }

    @Override
    public <T> T ignoring(T mockObject) {
        return this.allowing(mockObject);
    }

    @Override
    public MethodClause ignoring(Matcher<?> mockObjectMatcher) {
        return this.allowing((Object)mockObjectMatcher);
    }

    @Override
    public <T> T never(T mockObject) {
        return this.exactly(0).of(mockObject);
    }

    private void addParameterMatcher(Matcher<?> matcher) {
        this.currentBuilder().addParameterMatcher(matcher);
    }

    @Override
    public <T> T with(Matcher<T> matcher) {
        this.addParameterMatcher(matcher);
        return null;
    }

    @Override
    public boolean with(Matcher<Boolean> matcher) {
        this.addParameterMatcher(matcher);
        return false;
    }

    @Override
    public byte with(Matcher<Byte> matcher) {
        this.addParameterMatcher(matcher);
        return 0;
    }

    @Override
    public short with(Matcher<Short> matcher) {
        this.addParameterMatcher(matcher);
        return 0;
    }

    public char with(Matcher<Character> matcher) {
        this.addParameterMatcher(matcher);
        return '\u0000';
    }

    @Override
    public int with(Matcher<Integer> matcher) {
        this.addParameterMatcher(matcher);
        return 0;
    }

    @Override
    public long with(Matcher<Long> matcher) {
        this.addParameterMatcher(matcher);
        return 0L;
    }

    @Override
    public float with(Matcher<Float> matcher) {
        this.addParameterMatcher(matcher);
        return 0.0f;
    }

    @Override
    public double with(Matcher<Double> matcher) {
        this.addParameterMatcher(matcher);
        return 0.0;
    }

    public boolean with(boolean value) {
        return (boolean)this.with((Object)IsEqual.equalTo((Object)value));
    }

    public byte with(byte value) {
        return (byte)this.with((Object)IsEqual.equalTo((Object)value));
    }

    public short with(short value) {
        return (short)this.with((Object)IsEqual.equalTo((Object)value));
    }

    public char with(char value) {
        return (char)this.with((Object)IsEqual.equalTo((Object)Character.valueOf(value)));
    }

    public int with(int value) {
        return (int)this.with((Object)IsEqual.equalTo((Object)value));
    }

    public long with(long value) {
        return (long)this.with((Object)IsEqual.equalTo((Object)value));
    }

    public float with(float value) {
        return (float)this.with((Object)IsEqual.equalTo((Object)Float.valueOf(value)));
    }

    public double with(double value) {
        return (double)this.with((Object)IsEqual.equalTo((Object)value));
    }

    public <T> T with(T value) {
        return (T)this.with((T)IsEqual.equalTo(value));
    }

    @Override
    public void will(Action action) {
        this.currentBuilder().setAction(action);
    }

    public static <T> Matcher<T> equal(T value) {
        return new IsEqual(value);
    }

    public static <T> Matcher<T> same(T value) {
        return new IsSame(value);
    }

    public static <T> Matcher<T> any(Class<T> type) {
        return new IsAnything();
    }

    public static <T> Matcher<T> anything() {
        return new IsAnything();
    }

    @Deprecated
    public static Matcher<Object> a(Class<?> type) {
        return new IsInstanceOf(type);
    }

    @Deprecated
    public static Matcher<Object> an(Class<?> type) {
        return new IsInstanceOf(type);
    }

    public static <T> Matcher<T> aNull(Class<T> type) {
        return new IsNull();
    }

    public static <T> Matcher<T> aNonNull(Class<T> type) {
        return new IsNot((Matcher)new IsNull());
    }

    public static Action returnValue(Object result) {
        return new ReturnValueAction(result);
    }

    public static Action throwException(Throwable throwable) {
        return new ThrowAction(throwable);
    }

    public static Action returnIterator(Collection<?> collection) {
        return new ReturnIteratorAction(collection);
    }

    public static <T> Action returnIterator(T ... items) {
        return new ReturnIteratorAction(items);
    }

    public static Action returnEnumeration(Collection<?> collection) {
        return new ReturnEnumerationAction(collection);
    }

    public static <T> Action returnEnumeration(T ... items) {
        return new ReturnEnumerationAction(items);
    }

    public static Action doAll(Action ... actions) {
        return new DoAllAction(actions);
    }

    public static Action onConsecutiveCalls(Action ... actions) {
        return new ActionSequence(actions);
    }

    public void when(StatePredicate predicate) {
        this.currentBuilder().addOrderingConstraint(new InStateOrderingConstraint(predicate));
    }

    public void then(State state) {
        this.currentBuilder().addSideEffect(new ChangeStateSideEffect(state));
    }

    public void inSequence(Sequence sequence) {
        this.currentBuilder().addInSequenceOrderingConstraint(sequence);
    }

    public void inSequences(Sequence ... sequences) {
        for (Sequence sequence : sequences) {
            this.inSequence(sequence);
        }
    }
}

