/*
 * Decompiled with CFR 0.152.
 */
package com.phloc.commons.xml.namespace;

import com.phloc.commons.annotations.Nonempty;
import com.phloc.commons.collections.iterate.SingleElementIterator;
import com.phloc.commons.string.StringHelper;
import com.phloc.commons.string.ToStringGenerator;
import com.phloc.commons.xml.namespace.AbstractNamespaceContext;
import java.util.Iterator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class SingleElementNamespaceContext
extends AbstractNamespaceContext {
    private final String m_sPrefix;
    private final String m_sNamespaceURI;

    public SingleElementNamespaceContext(@Nonnull @Nonempty String string) {
        this("", string);
    }

    public SingleElementNamespaceContext(@Nonnull String string, @Nonnull @Nonempty String string2) {
        if (string == null) {
            throw new NullPointerException("prefix");
        }
        if (StringHelper.hasNoText(string2)) {
            throw new IllegalArgumentException("namespaceURI may not be empty");
        }
        this.m_sPrefix = string;
        this.m_sNamespaceURI = string2;
    }

    @Override
    @Nullable
    public String getDefaultNamespaceURI() {
        return this.m_sPrefix.equals("") ? this.m_sNamespaceURI : null;
    }

    @Override
    @Nullable
    protected Iterator<String> getCustomPrefixes(@Nullable String string) {
        return this.m_sNamespaceURI.equals(string) ? SingleElementIterator.create(this.m_sPrefix) : null;
    }

    @Override
    @Nullable
    protected String getCustomPrefix(@Nullable String string) {
        return this.m_sNamespaceURI.equals(string) ? this.m_sPrefix : null;
    }

    @Override
    @Nullable
    protected String getCustomNamespaceURI(@Nullable String string) {
        return this.m_sPrefix.equals(string) ? this.m_sNamespaceURI : null;
    }

    public String toString() {
        return new ToStringGenerator(this).append("prefix", this.m_sPrefix).append("namespaceURI", this.m_sNamespaceURI).toString();
    }
}

