/*
 * Decompiled with CFR 0.152.
 */
package fr.index.cloud.ens.virusscan;

import fr.index.cloud.ens.virusscan.ScanChecker;
import fr.index.cloud.ens.virusscan.ScanResult;
import fr.index.cloud.ens.virusscan.VirusScanException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DataModel;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;

public class ScanListener
implements EventListener {
    private static final Log log = LogFactory.getLog(ScanListener.class);
    private static String DEFAULT_ERROR_VIRUS_FOUND_MESSAGE = "Virus found";
    private static String ERROR_VIRUS_FOUND_LOCALIZED_MESSAGE = "label.error.index.custom.virusFound";
    public static final long SCAN_TIMEOUT = 10L;

    public void handleEvent(Event event) throws ClientException {
        DocumentModel docToCreate;
        DataModel dm;
        DocumentEventContext evtCtx;
        DocumentModel docToUpdate;
        if (log.isDebugEnabled()) {
            log.debug((Object)("ScanListener.handleEvent " + event.getName()));
        }
        if (event.getContext() instanceof DocumentEventContext && "beforeDocumentModification".equals(event.getName()) && (docToUpdate = (evtCtx = (DocumentEventContext)event.getContext()).getSourceDocument()).hasSchema("file") && docToUpdate != null && (dm = docToUpdate.getDataModel("file")) != null && dm.isDirty()) {
            this.checkFile(event, docToUpdate);
        }
        if ((event.getContext() instanceof DocumentEventContext && "aboutToCreate".equals(event.getName()) || "aboutToImport".equals(event.getName())) && (docToCreate = (evtCtx = (DocumentEventContext)event.getContext()).getSourceDocument()).hasSchema("file")) {
            this.checkFile(event, docToCreate);
        }
    }

    private void checkFile(Event event, DocumentModel docToScan) {
        ScanResult res = ScanChecker.getInstance().checkFile(docToScan, event.getContext().getCoreSession(), false, 10L);
        if (res.getErrorCode() == 1) {
            event.markBubbleException();
            throw new VirusScanException(DEFAULT_ERROR_VIRUS_FOUND_MESSAGE, ERROR_VIRUS_FOUND_LOCALIZED_MESSAGE, null);
        }
    }
}

