/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.collab.tools.forum;

import fr.toutatice.ecm.platform.core.listener.ToutaticeDocumentEventListenerHelper;
import java.io.Serializable;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.comment.api.CommentManager;
import org.nuxeo.runtime.api.Framework;

public class ThreadUpdateListener
implements EventListener {
    protected static CommentManager commentManager;

    protected static synchronized CommentManager getCommentManager() {
        if (commentManager == null) {
            commentManager = (CommentManager)Framework.getService(CommentManager.class);
        }
        return commentManager;
    }

    public void handleEvent(Event event) throws ClientException {
        if (event.getContext() instanceof DocumentEventContext) {
            String eventName = event.getName();
            DocumentEventContext docCtx = (DocumentEventContext)event.getContext();
            CoreSession session = docCtx.getCoreSession();
            DocumentModel srcDoc = docCtx.getSourceDocument();
            if (srcDoc != null && ToutaticeDocumentEventListenerHelper.isAlterableDocument((DocumentModel)srcDoc)) {
                boolean isThreadCreated;
                boolean isThread = "Thread".equals(srcDoc.getType());
                boolean bl = isThreadCreated = isThread && "documentCreated".equals(eventName);
                if (isThreadCreated) {
                    this.initializeThread(srcDoc);
                } else {
                    DocumentModel comment;
                    boolean isCommentAddedOrRemoved;
                    boolean bl2 = isCommentAddedOrRemoved = "commentAdded".equals(eventName) || "commentRemoved".equals(eventName);
                    if (isCommentAddedOrRemoved && "Post".equals((comment = (DocumentModel)docCtx.getProperty("comment_document")).getType()) && isThread) {
                        this.updateAnswersOfThread(srcDoc, session);
                    }
                }
            }
        }
    }

    private void initializeThread(DocumentModel thread) {
        GregorianCalendar dateCreation = (GregorianCalendar)thread.getPropertyValue("dc:created");
        thread.setPropertyValue("ttcth:lastCommentDate", (Serializable)dateCreation);
    }

    public void updateAnswersOfThread(DocumentModel thread, CoreSession session) {
        session.save();
        List answers = ThreadUpdateListener.getCommentManager().getComments(thread);
        Serializable lastCommentAuthor = thread.getPropertyValue("dc:creator");
        GregorianCalendar lastCommentDate = (GregorianCalendar)thread.getPropertyValue("dc:created");
        for (DocumentModel answer : answers) {
            Serializable author = answer.getPropertyValue("post:author");
            GregorianCalendar creationDate = (GregorianCalendar)answer.getPropertyValue("post:creationDate");
            if (lastCommentDate != null && !lastCommentDate.before(creationDate)) continue;
            lastCommentDate = creationDate;
            lastCommentAuthor = author;
        }
        HashMap<String, Serializable> properties = new HashMap<String, Serializable>();
        properties.put("ttcth:nbComments", Integer.valueOf(answers.size()));
        properties.put("ttcth:lastCommentDate", lastCommentDate);
        properties.put("ttcth:lastCommentAuthor", lastCommentAuthor);
        UnrestrictedPropertySetter propertySetter = new UnrestrictedPropertySetter(session, thread.getRef(), properties);
        propertySetter.runUnrestricted();
    }

    protected class UnrestrictedPropertySetter
    extends UnrestrictedSessionRunner {
        DocumentRef docRef;
        Map<String, Serializable> properties;

        protected UnrestrictedPropertySetter(CoreSession session, DocumentRef docRef, Map<String, Serializable> properties) {
            super(session);
            this.docRef = docRef;
            this.properties = properties;
        }

        public void run() throws ClientException {
            DocumentModel doc = this.session.getSourceDocument(this.docRef);
            if (doc != null) {
                for (Map.Entry<String, Serializable> property : this.properties.entrySet()) {
                    doc.setPropertyValue(property.getKey(), property.getValue());
                }
                this.session.saveDocument(doc);
            }
        }
    }
}

