/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.procedures.instances.operation.runner;

import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.platform.routing.api.DocumentRoute;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.ecm.platform.routing.core.api.DocumentRoutingEngineService;
import org.osivia.procedures.exception.ProcedureException;
import org.osivia.procedures.utils.ProcedureHelper;

public class UnrestrictedCancelProcedure
extends UnrestrictedSessionRunner {
    private DocumentModel procedureInstance;
    private boolean deletePi;
    private DocumentRoutingEngineService engineService;

    public UnrestrictedCancelProcedure(CoreSession session, DocumentRoutingService routingService, DocumentRoutingEngineService engineService, DocumentModel procedureInstance, boolean deletePi) {
        super(session);
        this.procedureInstance = procedureInstance;
        this.deletePi = deletePi;
        this.engineService = engineService;
    }

    public void run() throws ClientException {
        this.cancelProcedure(this.session, this.engineService, this.procedureInstance);
        if (this.deletePi) {
            this.removeProcedureInstance(this.session, this.procedureInstance);
        }
    }

    public void cancelProcedure(CoreSession session, DocumentRoutingEngineService engineService, DocumentModel procedureInstance) throws ProcedureException {
        DocumentRoute routeInstance = ProcedureHelper.getInstance().getProcedureAsRoute(session, procedureInstance);
        if (routeInstance.getDocument() == null) {
            throw new ProcedureException("No workflow process associated with ProcedureInstance: ".concat(procedureInstance.getId()));
        }
        engineService.cancel(routeInstance, session);
    }

    public void removeProcedureInstance(CoreSession session, DocumentModel procedureInstance) {
        session.removeDocument(procedureInstance.getRef());
    }
}

