/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.web.publication;

import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import fr.toutatice.ecm.platform.web.context.ToutaticeNavigationContext;
import fr.toutatice.ecm.platform.web.document.ToutaticeDocumentActionsBean;
import fr.toutatice.ecm.platform.web.publication.finder.ToutaticeRootSectionsFinder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.platform.publisher.api.PublicationTree;
import org.nuxeo.ecm.platform.publisher.api.PublicationTreeNotAvailable;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocument;
import org.nuxeo.ecm.platform.publisher.impl.service.ProxyNode;
import org.nuxeo.ecm.platform.publisher.impl.service.ProxyTree;
import org.nuxeo.ecm.platform.publisher.web.PublishActionsBean;
import org.nuxeo.ecm.platform.ui.web.util.SeamComponentCallHelper;
import org.nuxeo.ecm.webapp.action.DeleteActions;
import org.richfaces.component.UITree;

@Name(value="publishActions")
@Scope(value=ScopeType.CONVERSATION)
@Install(precedence=31)
public class ToutaticePublishActionsBean
extends PublishActionsBean {
    private static final Log log = LogFactory.getLog(ToutaticePublishActionsBean.class);
    private static final long serialVersionUID = 1L;
    private ToutaticeDocumentActionsBean documentActions;
    private DeleteActions deleteActions;

    protected ToutaticeDocumentActionsBean getToutaticeDocumentActionBean() {
        if (this.documentActions == null) {
            this.documentActions = (ToutaticeDocumentActionsBean)SeamComponentCallHelper.getSeamComponentByName((String)"documentActions");
        }
        return this.documentActions;
    }

    protected DeleteActions getDeleteActions() {
        if (this.deleteActions == null) {
            this.deleteActions = (DeleteActions)SeamComponentCallHelper.getSeamComponentByName((String)"deleteActions");
        }
        return this.deleteActions;
    }

    public boolean getCanPublish() throws ClientException {
        DocumentModel doc = this.navigationContext.getCurrentDocument();
        return this.getCanPublish(doc);
    }

    public boolean getCanPublish(DocumentModel document) throws ClientException {
        boolean can = false;
        try {
            if (document != null && ToutaticeDocumentHelper.isInPublishSpace((CoreSession)this.documentManager, (DocumentModel)document)) {
                boolean canWrite = this.documentManager.hasPermission(document.getRef(), "Write");
                boolean canPublish = this.documentManager.hasPermission(document.getRef(), "validationWorkflow_validation");
                boolean bl = can = canWrite && canPublish;
                if (can) {
                    DocumentModel proxy;
                    DocumentRef parentRef = document.getParentRef();
                    DocumentModelList proxies = this.documentManager.getProxies(document.getRef(), parentRef);
                    if (proxies != null && !proxies.isEmpty() && (proxy = (DocumentModel)proxies.get(0)).getVersionLabel().equals(document.getVersionLabel())) {
                        can = false;
                    }
                }
            }
        }
        catch (Exception e) {
            log.debug((Object)("Failed to check the permission to publish the document '" + document.getTitle() + "', error: " + e.getMessage()));
        }
        return can;
    }

    public boolean getCanUnpublish() throws ClientException {
        DocumentModel doc = this.navigationContext.getCurrentDocument();
        return this.getCanUnpublish(doc);
    }

    public boolean canUnpublishProxy(DocumentModel proxy) throws ClientException {
        boolean status = false;
        if (proxy != null && proxy.isProxy() && !proxy.hasFacet("isRemoteProxy")) {
            status = this.documentManager.hasPermission(proxy.getRef(), "validationWorkflow_validation");
        }
        return status;
    }

    public boolean getCanUnpublish(DocumentModel document) throws ClientException {
        boolean status = false;
        try {
            DocumentModelList proxies;
            DocumentRef parentRef;
            if (null != document && null != (parentRef = this.documentManager.getParentDocumentRef(document.getRef())) && (proxies = this.documentManager.getProxies(document.getRef(), parentRef)) != null && !proxies.isEmpty()) {
                DocumentModel proxy = (DocumentModel)proxies.get(0);
                status = this.canUnpublishProxy(proxy);
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to check the permission to unpublish the document '" + document.getTitle() + "', error: " + e.getMessage()));
        }
        return status;
    }

    public boolean getCanPublishSelection() {
        boolean status = false;
        try {
            DocumentModel selectedDocument;
            List currentDocumentSelection = this.documentsListsManager.getWorkingList("CURRENT_SELECTION");
            Iterator iterator = currentDocumentSelection.iterator();
            while (iterator.hasNext() && (status = this.getCanPublish(selectedDocument = (DocumentModel)iterator.next()))) {
            }
        }
        catch (Exception e) {
            log.error((Object)("Failed to check permission to publish the selection, error: " + e.getMessage()));
        }
        return status;
    }

    public boolean getCanUnPublishSelection() {
        boolean can = false;
        List currentDocumentSelection = this.documentsListsManager.getWorkingList("CURRENT_SELECTION");
        if (CollectionUtils.isNotEmpty((Collection)currentDocumentSelection)) {
            ArrayList<DocumentModel> lcPxs = new ArrayList<DocumentModel>();
            ArrayList<DocumentModel> rmPxs = new ArrayList<DocumentModel>();
            for (DocumentModel pxy : currentDocumentSelection) {
                if (pxy.hasFacet("isRemoteProxy")) {
                    rmPxs.add(pxy);
                    continue;
                }
                lcPxs.add(pxy);
            }
            try {
                boolean canLcPxs = true;
                if (CollectionUtils.isNotEmpty(lcPxs)) {
                    Iterator itLcPxy = lcPxs.iterator();
                    while (itLcPxy.hasNext() && canLcPxs) {
                        DocumentModel lcPxy = (DocumentModel)itLcPxy.next();
                        canLcPxs = this.getCanUnpublish(lcPxy);
                    }
                    can = canLcPxs;
                }
                boolean canRmPxs = true;
                if (canLcPxs && CollectionUtils.isNotEmpty(rmPxs)) {
                    if (this.getDeleteActions().checkDeletePermOnParents(rmPxs)) {
                        Iterator itRmPxs = rmPxs.iterator();
                        while (itRmPxs.hasNext() && canRmPxs) {
                            DocumentModel rmPxy = (DocumentModel)itRmPxs.next();
                            canRmPxs = !rmPxy.hasFacet("PublishSpace") && !rmPxy.hasFacet("MasterPublishSpace");
                        }
                    } else {
                        canRmPxs = false;
                    }
                    can = canRmPxs;
                }
            }
            catch (Exception e) {
                log.error((Object)("Failed to check permission to publish the selection, error: " + e.getMessage()));
            }
        }
        return can;
    }

    public boolean isRemoteProxy(DocumentModel proxy) {
        return proxy.isProxy() && !StringUtils.endsWith((String)proxy.getName(), (String)".proxy");
    }

    protected void getPathFragments(DocumentModel document, List<String> pathFragments) throws ClientException {
        pathFragments.add(document.getTitle());
        DocumentModel sectionRoot = ((ToutaticeNavigationContext)this.navigationContext).getSectionPublicationArea(document);
        if (!sectionRoot.equals(document)) {
            pathFragments.add(sectionRoot.getTitle());
        }
        DocumentModel domain = ((ToutaticeNavigationContext)this.navigationContext).getDocumentDomain(document);
        pathFragments.add(domain.getTitle());
    }

    public String getIconPath(Object node) throws ClientException {
        String iconPath = "";
        if (node instanceof ProxyNode) {
            String path = ((ProxyNode)node).getPath();
            PathRef pathRef = new PathRef(path);
            DocumentModel document = this.documentManager.getDocument((DocumentRef)pathRef);
            iconPath = (String)document.getProperty("common", "icon");
        }
        if (node instanceof ProxyTree) {
            iconPath = "/icons/domain.gif";
        }
        return iconPath;
    }

    public Boolean advisedNodeOpened(UITree tree) {
        return Boolean.TRUE;
    }

    public boolean isPending() throws ClientException {
        return this.isPending(this.navigationContext.getCurrentDocument());
    }

    public boolean isPending(DocumentModel document) throws ClientException {
        boolean isPending = false;
        if (ToutaticeDocumentHelper.isDocStillExists((CoreSession)this.documentManager, (DocumentModel)document) && document.isProxy()) {
            PublicationTree tree = this.publisherService.getPublicationTreeFor(document, this.documentManager);
            PublishedDocument publishedDocument = tree.wrapToPublishedDocument(document);
            isPending = publishedDocument.isPending();
        }
        return isPending;
    }

    public boolean hasRemoteProxy() throws ClientException {
        boolean has = false;
        DocumentModel currentDocument = this.navigationContext.getCurrentDocument();
        DocumentModelList proxies = this.documentManager.getProxies(currentDocument.getRef(), null);
        if (proxies != null && proxies.size() > 0) {
            Iterator iterator = proxies.iterator();
            while (iterator.hasNext() && !has) {
                DocumentModel proxy = (DocumentModel)iterator.next();
                if (!this.isRemoteProxy(proxy)) continue;
                has = true;
            }
        }
        return has;
    }

    protected List<String> filterEmptyTrees(Collection<String> trees) throws PublicationTreeNotAvailable, ClientException {
        ArrayList<String> filteredTrees = new ArrayList<String>();
        ToutaticeRootSectionsFinder finder = new ToutaticeRootSectionsFinder(this.documentManager);
        DocumentModelList accessibleSections = finder.getAccessibleSectionRoots(this.navigationContext.getCurrentDocument());
        for (String tree : trees) {
            try {
                PublicationTree pTree;
                String treeDomain = StringUtils.substringAfter((String)tree, (String)"-");
                boolean inDomain = false;
                for (DocumentModel section : accessibleSections) {
                    if (!section.getPathAsString().startsWith("/" + treeDomain)) continue;
                    inDomain = true;
                }
                if (!inDomain) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)("#filterEmptyTrees: == [LOOP: Selected tree]: " + tree));
                }
                if ((pTree = this.publisherService.getPublicationTree(tree, this.documentManager, null, this.navigationContext.getCurrentDocument())) == null) continue;
                if (pTree.getTreeType().equals("ToutaticeRootSectionsPublicationTree")) {
                    if (pTree.getChildrenNodes().size() <= 0) continue;
                    filteredTrees.add(tree);
                    continue;
                }
                filteredTrees.add(tree);
            }
            catch (PublicationTreeNotAvailable e) {
                log.warn((Object)("Publication tree " + tree + " is not available : check config"));
                log.debug((Object)("Publication tree " + tree + " is not available : root cause is "), (Throwable)e);
            }
        }
        return filteredTrees;
    }
}

