/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.opencmis.bindings;

import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.apache.chemistry.opencmis.commons.server.CmisServiceFactory;
import org.nuxeo.ecm.core.opencmis.bindings.NuxeoCmisServiceFactory;
import org.nuxeo.ecm.core.opencmis.bindings.NuxeoCmisServiceFactoryManager;
import org.nuxeo.runtime.RuntimeService;
import org.nuxeo.runtime.RuntimeServiceEvent;
import org.nuxeo.runtime.RuntimeServiceListener;
import org.nuxeo.runtime.api.Framework;

public class NuxeoCmisContextListener
implements ServletContextListener {
    public void contextInitialized(final ServletContextEvent sce) {
        RuntimeService runtime = Framework.getRuntime();
        if (runtime == null || !runtime.isStarted()) {
            Framework.addListener((RuntimeServiceListener)new RuntimeServiceListener(){

                public void handleEvent(RuntimeServiceEvent event) {
                    if (event.id != 1) {
                        return;
                    }
                    Framework.removeListener((RuntimeServiceListener)this);
                    NuxeoCmisContextListener.this.activate(sce);
                }
            });
        } else {
            this.activate(sce);
        }
    }

    protected void activate(ServletContextEvent sce) {
        NuxeoCmisServiceFactoryManager manager = (NuxeoCmisServiceFactoryManager)((Object)Framework.getService(NuxeoCmisServiceFactoryManager.class));
        NuxeoCmisServiceFactory factory = manager.getNuxeoCmisServiceFactory();
        sce.getServletContext().setAttribute("org.apache.chemistry.opencmis.servicesfactory", (Object)factory);
    }

    public void contextDestroyed(ServletContextEvent sce) {
        CmisServiceFactory factory = (CmisServiceFactory)sce.getServletContext().getAttribute("org.apache.chemistry.opencmis.servicesfactory");
        if (factory != null) {
            factory.destroy();
        }
    }
}

