/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.elasticsearch.codec;

import fr.toutatice.ecm.elasticsearch.search.TTCSearchResponse;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.codehaus.jackson.JsonGenerator;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.nuxeo.ecm.automation.io.services.codec.ObjectCodec;

public class TTCEsCodec
extends ObjectCodec<TTCSearchResponse> {
    public TTCEsCodec() {
        super(TTCSearchResponse.class);
    }

    public String getType() {
        return "esresponse";
    }

    public void write(JsonGenerator jg, TTCSearchResponse value) throws IOException {
        SearchHits upperhits = value.getSearchResponse().getHits();
        String schemasRegex = value.getSchemasRegex();
        SearchHit[] searchhits = upperhits.getHits();
        jg.writeStartObject();
        jg.writeStringField("entity-type", "documents");
        if (value.isPaginable()) {
            jg.writeBooleanField("isPaginable", value.isPaginable());
            jg.writeNumberField("resultsCount", searchhits.length);
            jg.writeNumberField("totalSize", upperhits.getTotalHits());
            jg.writeNumberField("pageSize", value.getPageSize());
            long pageCount = 0L;
            if (value.getPageSize() > 0) {
                pageCount = upperhits.getTotalHits() / (long)value.getPageSize() + (long)(0L < upperhits.getTotalHits() % (long)value.getPageSize() ? 1 : 0);
            }
            jg.writeNumberField("pageCount", pageCount);
            jg.writeNumberField("currentPageIndex", value.getCurrentPageIndex());
        }
        jg.writeArrayFieldStart("entries");
        for (SearchHit hit : searchhits) {
            Map source = hit.getSource();
            jg.writeStartObject();
            jg.writeStringField("entity-type", "document");
            jg.writeStringField("repository", (String)source.get("ecm:repository"));
            jg.writeStringField("uid", (String)source.get("ecm:uuid"));
            jg.writeStringField("path", (String)source.get("ecm:path"));
            jg.writeStringField("type", (String)source.get("ecm:primaryType"));
            jg.writeStringField("state", (String)source.get("ecm:currentLifeCycleState"));
            jg.writeStringField("parentRef", (String)source.get("ecm:parentId"));
            jg.writeStringField("versionLabel", (String)source.get("ecm:versionLabel"));
            jg.writeStringField("isCheckedOut", "");
            jg.writeStringField("title", (String)source.get("dc:title"));
            jg.writeStringField("lastModified", (String)source.get("dc:modified"));
            jg.writeObjectField("facets", (Object)((List)source.get("ecm:mixinType")));
            jg.writeStringField("changeToken", (String)source.get("ecm:changeToken"));
            jg.writeObjectFieldStart("properties");
            for (String key : source.keySet()) {
                if (key.matches("ecm:.+") || !key.matches(schemasRegex)) continue;
                jg.writeObjectField(key, source.get(key));
            }
            jg.writeEndObject();
            jg.writeEndObject();
            jg.flush();
        }
        jg.writeEndArray();
        jg.writeEndObject();
        jg.flush();
    }
}

