/*
 * Decompiled with CFR 0.152.
 */
package org.opentoutatice.addon.quota.listener;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.opentoutatice.addon.quota.check.QuotaChecker;
import org.opentoutatice.addon.quota.check.exception.QuotaExceededException;

public class QuotaListener
implements EventListener {
    private static final Log log = LogFactory.getLog(QuotaListener.class);

    public void handleEvent(Event event) throws ClientException {
        block9: {
            if (log.isDebugEnabled()) {
                log.debug((Object)("QuotaListener.handleEvent " + event.getName()));
            }
            if (event.getContext() instanceof DocumentEventContext && "aboutToCreate".equals(event.getName()) || "aboutToImport".equals(event.getName()) || "aboutToCopy".equals(event.getName())) {
                DocumentEventContext evtCtx = (DocumentEventContext)event.getContext();
                DocumentEventContext s = (DocumentEventContext)event.getContext();
                long size = 0L;
                DocumentModel docToCreate = evtCtx.getSourceDocument();
                if ("aboutToCopy".equals(event.getName()) && docToCreate.hasFacet("Folderish")) {
                    DocumentModel srcFolder = (DocumentModel)event.getContext().getArguments()[0];
                    size = QuotaChecker.get().getTreeSizeFor(evtCtx.getCoreSession(), new PathRef(srcFolder.getPath().toString()));
                } else {
                    BlobHolder bHolder = (BlobHolder)docToCreate.getAdapter(BlobHolder.class);
                    if (bHolder != null && bHolder.getBlob() != null) {
                        size = bHolder.getBlob().getLength();
                    }
                }
                if (size != 0L) {
                    try {
                        QuotaChecker.get().checkExceeding(evtCtx.getCoreSession(), docToCreate, size);
                    }
                    catch (Exception e) {
                        if (log.isDebugEnabled()) {
                            log.debug((Object)"Quota exceeded ");
                        }
                        if (!(e instanceof QuotaExceededException)) break block9;
                        event.markBubbleException();
                        throw e;
                    }
                }
            }
        }
    }
}

