/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.server.support.filter;

public class JsonPrettyPrinter {
    private int indent = 0;
    private String indentStr;
    private StringBuilder sb = new StringBuilder();

    public JsonPrettyPrinter() {
        this.init(3);
    }

    public JsonPrettyPrinter(int indent) {
        this.init(indent);
    }

    private void init(int indent) {
        StringBuilder indentBuilder = new StringBuilder(indent);
        for (int i = 0; i < indent; ++i) {
            indentBuilder.append(' ');
        }
        this.indentStr = indentBuilder.toString();
    }

    public String prettyPrint(String jsonStr) {
        for (int i = 0; i < jsonStr.length(); ++i) {
            char c = jsonStr.charAt(i);
            this.writeChar(c);
        }
        return this.sb.toString();
    }

    private void writeChar(char c) {
        if (c == '[' || c == '{') {
            this.sb.append(c);
            this.sb.append('\n');
            ++this.indent;
            this.addIndent();
        } else if (c == ',') {
            this.sb.append(c);
            this.sb.append('\n');
            this.addIndent();
        } else if (c == ']' || c == '}') {
            this.sb.append('\n');
            --this.indent;
            this.addIndent();
            this.sb.append(c);
        } else {
            this.sb.append(c);
        }
    }

    private void addIndent() {
        for (int i = 0; i < this.indent; ++i) {
            this.sb.append(this.indentStr);
        }
    }
}

