/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.web.fn;

import fr.toutatice.ecm.platform.service.url.ToutaticeDocumentLocation;
import java.io.Serializable;
import java.util.HashMap;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentLocation;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.platform.ui.web.rest.api.URLPolicyService;
import org.nuxeo.ecm.platform.ui.web.tag.fn.DocumentModelFunctions;
import org.nuxeo.ecm.platform.ui.web.util.BaseURL;
import org.nuxeo.ecm.platform.url.DocumentViewImpl;
import org.nuxeo.ecm.platform.url.api.DocumentView;
import org.nuxeo.runtime.api.Framework;

public class WebIdFunctions {
    private static final String PATH_PATTERN = "default";
    private static final String WEBID_PATTERN = "webidpattern";
    private static final Log log = LogFactory.getLog(WebIdFunctions.class);
    private static final String WEBID_DOWNLOAD_PICTURE = "webiddownloadpicture";
    private static final String PSL_MARKER = "?l=";
    protected static URLPolicyService urlService;

    public static URLPolicyService getURLPolicyService() {
        if (urlService == null) {
            urlService = (URLPolicyService)Framework.getService(URLPolicyService.class);
        }
        return urlService;
    }

    public static boolean hasWebId(DocumentModel doc) {
        boolean ret = false;
        try {
            Serializable webid;
            if (doc != null && (webid = doc.getProperty("ttc:webid").getValue()) != null && StringUtils.isNotBlank((String)webid.toString())) {
                ret = true;
            }
        }
        catch (ClientException e) {
            log.error((Object)("Erreur g\u00e9n\u00e9ration webid " + (Object)((Object)e)));
        }
        return ret;
    }

    public static String getPreferredLinkUrl(DocumentModel doc) {
        String url = "";
        try {
            String webid = (String)((Object)doc.getPropertyValue("ttc:webid"));
            url = StringUtils.isNotBlank((String)webid) ? WebIdFunctions.callWebIdCodec(doc, null) : DocumentModelFunctions.documentUrl((DocumentModel)doc);
        }
        catch (ClientException e) {
            log.error((Object)("Erreur g\u00e9n\u00e9ration webid " + (Object)((Object)e)));
        }
        return url;
    }

    public static String getPreferredImgUrl(String patternName, DocumentModel doc, String blobPropertyName, String filename) {
        String url = "";
        try {
            String webid = (String)((Object)doc.getPropertyValue("ttc:webid"));
            url = StringUtils.isNotBlank((String)webid) ? WebIdFunctions.callWebIdCodec(doc, blobPropertyName) : DocumentModelFunctions.fileUrl((String)patternName, (DocumentModel)doc, (String)blobPropertyName, (String)filename);
        }
        catch (ClientException e) {
            log.error((Object)("Erreur g\u00e9n\u00e9ration webid " + (Object)((Object)e)));
        }
        return url;
    }

    public static String getPreferredDisplayId(DocumentModel doc) {
        String id = "";
        try {
            String webid = (String)((Object)doc.getPropertyValue("ttc:webid"));
            id = StringUtils.isNotBlank((String)webid) ? StringUtils.replace((String)ToutaticeDocumentLocation.getLogicalWebId((DocumentModel)doc), (String)"_c_", (String)PSL_MARKER) : doc.getPathAsString();
        }
        catch (Exception e) {
            log.error((Object)("Erreur g\u00e9n\u00e9ration webid " + e));
        }
        return id;
    }

    private static String callWebIdCodec(DocumentModel doc, String blobPropertyName) {
        String url = "";
        try {
            HashMap<String, String> parameters = new HashMap<String, String>();
            if ("Picture".equals(doc.getType()) && StringUtils.isNotBlank((String)blobPropertyName)) {
                parameters.put("content", StringUtils.replace((String)blobPropertyName, (String)":content", (String)""));
            }
            ToutaticeDocumentLocation webIdDocLoc = new ToutaticeDocumentLocation(doc);
            DocumentViewImpl docView = new DocumentViewImpl((DocumentLocation)webIdDocLoc, null, parameters);
            url = WebIdFunctions.getURLPolicyService().getUrlFromDocumentView(WEBID_PATTERN, (DocumentView)docView, BaseURL.getBaseURL());
        }
        catch (ClientException e) {
            log.error((Object)("Erreur g\u00e9n\u00e9ration webid " + (Object)((Object)e)));
        }
        catch (Exception e) {
            log.error((Object)("Erreur g\u00e9n\u00e9ration webid " + e));
        }
        return url;
    }

    protected static DocumentView getDownloadFileProperties(DocumentLocation docLoc, DocumentModel doc) throws PropertyException, ClientException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("FILE_PROPERTY_PATH", "file:content");
        String fileName = (String)((Object)doc.getPropertyValue("file:filename"));
        parameters.put("FILENAME", fileName);
        return new DocumentViewImpl(docLoc, null, parameters);
    }

    protected static DocumentView getDownloadPictureProperties(DocumentLocation docLoc, DocumentModel doc, String blobPropertyName) throws PropertyException, ClientException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        if (StringUtils.isNotBlank((String)blobPropertyName)) {
            parameters.put("FILE_PROPERTY_PATH", blobPropertyName);
        } else {
            parameters.put("FILE_PROPERTY_PATH", "Original:content");
        }
        String fileName = doc.getPropertyValue("dc:modified").toString();
        parameters.put("FILENAME", fileName);
        return new DocumentViewImpl(docLoc, null, parameters);
    }
}

