/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.webengine.util;

import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.core.api.security.UserEntry;
import org.nuxeo.ecm.core.api.security.impl.UserEntryImpl;

public class ACLUtils {
    private ACLUtils() {
    }

    public static void removePermission(CoreSession session, DocumentRef docRef, String username, String permission) throws ClientException {
        int i;
        ACP acp = session.getACP(docRef);
        if (acp == null) {
            return;
        }
        ACL acl = acp.getACL(null);
        if (acl == null) {
            return;
        }
        ACE[] aces = acl.getACEs();
        for (i = 0; !(i >= aces.length || permission.equals(aces[i].getPermission()) && username.equals(aces[i].getUsername())); ++i) {
        }
        if (i == aces.length) {
            return;
        }
        UserEntry[] entries = new UserEntry[aces.length - 1];
        if (i == 0) {
            ACLUtils.copyTo(aces, 1, entries, 0, entries.length);
        } else if (i == aces.length - 1) {
            ACLUtils.copyTo(aces, 0, entries, 0, entries.length);
        } else {
            ACLUtils.copyTo(aces, 0, entries, 0, i);
            ACLUtils.copyTo(aces, i + 1, entries, i, entries.length - i - 1);
        }
        acp.setRules(entries, true);
        session.setACP(docRef, acp, true);
    }

    private static void copyTo(ACE[] aces, int s0, UserEntry[] entries, int s1, int len) {
        int i = s0;
        int k = s1;
        while (i < len) {
            ACE ace = aces[i];
            UserEntryImpl entry = new UserEntryImpl(ace.getUsername());
            entry.addPrivilege(ace.getPermission(), ace.isGranted(), false);
            entries[k] = entry;
            ++i;
            ++k;
        }
    }
}

