/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.apidoc.documentation;

import com.cforcoding.jmd.MarkDownParserAndSanitizer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.apidoc.api.AbstractDocumentationItem;
import org.nuxeo.apidoc.api.BaseNuxeoArtifact;
import org.nuxeo.apidoc.api.DocumentationItem;
import org.nuxeo.apidoc.introspection.BundleGroupImpl;
import org.nuxeo.apidoc.introspection.BundleInfoImpl;

public class ResourceDocumentationItem
extends AbstractDocumentationItem
implements DocumentationItem {
    protected String content;
    protected String filename;
    protected BaseNuxeoArtifact target;
    protected String type;

    public ResourceDocumentationItem(String filename, String content, BundleInfoImpl target, String type) {
        this.content = content;
        this.filename = filename;
        this.target = target;
        this.type = type;
    }

    public ResourceDocumentationItem(ResourceDocumentationItem other, BundleGroupImpl target) {
        this.content = other.content;
        this.filename = other.filename;
        this.target = target;
        this.type = other.type;
    }

    @Override
    public String getTitle() {
        return this.getCleanName() + " " + this.target.getId();
    }

    protected String getCleanName() {
        if (this.filename == null || this.filename.toLowerCase().startsWith("readme")) {
            return "ReadMe";
        }
        int idx = this.filename.indexOf(".");
        if (idx > 0) {
            return this.filename.substring(0, idx);
        }
        return this.filename;
    }

    @Override
    public String getContent() {
        MarkDownParserAndSanitizer parser = new MarkDownParserAndSanitizer();
        String xHtml = parser.transform(this.content);
        return xHtml;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public String getRenderingType() {
        return "html";
    }

    @Override
    public List<String> getApplicableVersion() {
        return Arrays.asList(this.target.getVersion());
    }

    @Override
    public String getTarget() {
        return this.target.getId();
    }

    @Override
    public String getTargetType() {
        return this.target.getArtifactType();
    }

    @Override
    public boolean isApproved() {
        return true;
    }

    @Override
    public String getId() {
        return this.getTargetType() + "--" + this.filename;
    }

    @Override
    public String getUUID() {
        return null;
    }

    @Override
    public Map<String, String> getAttachments() {
        return new HashMap<String, String>();
    }

    @Override
    public boolean isPlaceHolder() {
        return true;
    }

    @Override
    public String getEditId() {
        return null;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }
}

