/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.ui.select2.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.query.sql.NXQL;
import org.nuxeo.ecm.core.schema.types.Schema;
import org.nuxeo.runtime.api.Framework;

public class Select2Common {
    private static final Log log = LogFactory.getLog(Select2Common.class);
    private static final String FORCE_DISPLAY_EMAIL_IN_SUGGESTION = "nuxeo.ui.displayEmailInUserSuggestion";
    public static final String LANG_TOKEN = "{lang}";
    public static final String DEFAULT_LANG = "en";
    public static final String ID = "id";
    public static final String LABEL = "displayLabel";
    public static final String DIRECTORY_DEFAULT_LABEL_COL_NAME = "label";
    public static final String PARENT_FIELD_ID = "parent";
    public static final String PLACEHOLDER = "placeholder";
    public static final String COMPUTED_ID = "computedId";
    public static final String DEFAULT_KEY_SEPARATOR = "/";
    public static final String OBSOLETE_FIELD_ID = "obsolete";
    public static final List<String> SELECT2_USER_WIDGET_TYPE_LIST = new ArrayList<String>(Arrays.asList("singleUserSuggestion", "multipleUsersSuggestion"));
    public static final List<String> SELECT2_DOC_WIDGET_TYPE_LIST = new ArrayList<String>(Arrays.asList("singleDocumentSuggestion", "multipleDocumentsSuggestion"));
    public static final String USER_TYPE = "USER_TYPE";
    public static final String GROUP_TYPE = "GROUP_TYPE";
    public static final String TYPE_KEY_NAME = "type";
    public static final String PREFIXED_ID_KEY_NAME = "prefixed_id";
    public static final String SUGGESTION_FORMATTER = "suggestionFormatter";
    public static final String SELECTION_FORMATTER = "selectionFormatter";
    public static final String USER_DEFAULT_SUGGESTION_FORMATTER = "userEntryDefaultFormatter";
    public static final String DOC_DEFAULT_SUGGESTION_FORMATTER = "docEntryDefaultFormatter";
    public static final String WARN_MESSAGE_LABEL = "warn_message";
    public static final List<String> SELECT2_DIR_WIDGET_TYPE_LIST = new ArrayList<String>(Arrays.asList("suggestOneDirectory", "suggestManyDirectory"));
    public static final List<String> SELECT2_DEFAULT_DOCUMENT_SCHEMAS = new ArrayList<String>(Arrays.asList("dublincore", "common"));
    public static final String DIR_DEFAULT_SUGGESTION_FORMATTER = "dirEntryDefaultFormatter";
    public static final String READ_ONLY_PARAM = "readonly";
    public static final String RERENDER_JS_FUNCTION_NAME = "reRenderFunctionName";
    public static final String AJAX_RERENDER = "ajaxReRender";
    public static final String USER_DEFAULT_SELECTION_FORMATTER = "userSelectionDefaultFormatter";
    public static final String DOC_DEFAULT_SELECTION_FORMATTER = "docSelectionDefaultFormatter";
    public static final String DIR_DEFAULT_SELECTION_FORMATTER = "dirSelectionDefaultFormatter";
    public static final String WIDTH = "width";
    public static final String DEFAULT_WIDTH = "300";
    public static final String MIN_CHARS = "minChars";
    public static final int DEFAULT_MIN_CHARS = 3;
    public static final String TITLE = "title";
    public static final String DISPLAY_ICON = "displayIcon";
    public static final String OPERATION_ID = "operationId";
    public static final String DIRECTORY_ORDER_FIELD_NAME = "ordering";
    public static final String ABSOLUTE_LABEL = "absoluteLabel";
    private static Boolean forceDisplayEmailInSuggestion = null;
    public static final String ICON = "icon";

    private static boolean isForceDisplayEmailInSuggestion() {
        if (forceDisplayEmailInSuggestion == null) {
            forceDisplayEmailInSuggestion = Framework.isBooleanPropertyTrue((String)FORCE_DISPLAY_EMAIL_IN_SUGGESTION);
        }
        return forceDisplayEmailInSuggestion;
    }

    public static String[] getDefaultSchemas() {
        return Select2Common.getSchemas(null);
    }

    public static String getLabelFieldName(Schema schema, boolean dbl10n, String labelFieldName, String lang) {
        if (labelFieldName == null || labelFieldName.isEmpty()) {
            labelFieldName = DIRECTORY_DEFAULT_LABEL_COL_NAME;
        }
        if (dbl10n) {
            int i = labelFieldName.indexOf(LANG_TOKEN);
            if (i >= 0) {
                StringBuffer buf = new StringBuffer();
                buf.append(labelFieldName.substring(0, i));
                buf.append(lang);
                buf.append(labelFieldName.substring(i + LANG_TOKEN.length()));
                String result = buf.toString();
                if (schema.getField(result) != null) {
                    return result;
                }
                buf = new StringBuffer();
                buf.append(labelFieldName.substring(0, i));
                buf.append(DEFAULT_LANG);
                buf.append(labelFieldName.substring(i + LANG_TOKEN.length()));
                return buf.toString();
            }
            String result = labelFieldName + "_" + lang;
            if (schema.getField(result) != null) {
                return result;
            }
            log.warn((Object)String.format("Unable to find field %s in directory schema %s. Trying to fallback on default one.", labelFieldName, schema.getName()));
            result = "label_en";
            if (schema.getField(result) != null) {
                return result;
            }
            result = DIRECTORY_DEFAULT_LABEL_COL_NAME;
            if (schema.getField(result) != null) {
                return result;
            }
            if (schema.getField(labelFieldName) != null) {
                return labelFieldName;
            }
            throw new IllegalArgumentException(String.format("Unable to find field %s in directory schema %s", labelFieldName, schema.getName()));
        }
        if (schema.getField(labelFieldName) != null) {
            return labelFieldName;
        }
        throw new IllegalArgumentException(String.format("Unable to find field %s in directory schema %s", labelFieldName, schema.getName()));
    }

    public static String[] getSchemas(String schemaNames) {
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(SELECT2_DEFAULT_DOCUMENT_SCHEMAS);
        String[] temp = null;
        if (schemaNames != null && !schemaNames.isEmpty()) {
            temp = schemaNames.split(",");
        }
        if (temp != null) {
            for (String s : temp) {
                result.add(s);
            }
        }
        return result.toArray(new String[result.size()]);
    }

    public static void computeUserLabel(JSONObject obj, String firstLabelField, String secondLabelField, String thirdLabelField, boolean hideFirstLabel, boolean hideSecondLabel, boolean hideThirdLabel, boolean displayEmailInSuggestion, String userId) {
        String result = "";
        if (obj != null) {
            String lastname;
            if (StringUtils.isNotBlank((String)firstLabelField) && !hideFirstLabel) {
                String firstLabel = obj.optString(firstLabelField);
                result = result + (StringUtils.isNotBlank((String)firstLabel) ? firstLabel : "");
            } else if (!hideFirstLabel) {
                String firstname = obj.optString("firstName");
                result = result + (StringUtils.isNotBlank((String)firstname) ? firstname : "");
            }
            if (StringUtils.isNotBlank((String)secondLabelField) && !hideSecondLabel) {
                String secondLabel = obj.optString(firstLabelField);
                if (StringUtils.isNotBlank((String)secondLabel)) {
                    if (StringUtils.isNotBlank((String)result)) {
                        result = result + " ";
                    }
                    result = result + secondLabel;
                }
            } else if (!hideSecondLabel && StringUtils.isNotBlank((String)(lastname = obj.optString("lastName")))) {
                if (StringUtils.isNotBlank((String)result)) {
                    result = result + " ";
                }
                result = result + lastname;
            }
            if (StringUtils.isBlank((String)result)) {
                result = result + (StringUtils.isNotBlank((String)userId) ? userId : "");
            }
            if (Select2Common.isForceDisplayEmailInSuggestion() || displayEmailInSuggestion && !hideThirdLabel) {
                if (StringUtils.isNotBlank((String)thirdLabelField)) {
                    String thirdLabel = obj.optString(thirdLabelField);
                    if (StringUtils.isNotBlank((String)thirdLabel)) {
                        if (StringUtils.isNotBlank((String)result)) {
                            result = result + " ";
                        }
                        result = result + thirdLabel;
                    }
                } else {
                    String email = obj.optString("email");
                    if (StringUtils.isNotBlank((String)email)) {
                        if (StringUtils.isNotBlank((String)result)) {
                            result = result + " ";
                        }
                        result = result + email;
                    }
                }
            }
            obj.put((Object)LABEL, (Object)result);
        }
    }

    public static void computeGroupLabel(JSONObject obj, String groupId, String groupLabelField, boolean hideFirstLabel) {
        String groupLabelValue;
        String label = null;
        label = hideFirstLabel ? groupId : (StringUtils.isNotBlank((String)(groupLabelValue = obj.optString(groupLabelField))) ? groupLabelValue : groupId);
        obj.put((Object)LABEL, (Object)label);
    }

    public static void computeUserGroupIcon(JSONObject obj, boolean hideIcon) {
        if (obj != null && !hideIcon) {
            String userGroupType = obj.optString(TYPE_KEY_NAME);
            obj.element(DISPLAY_ICON, StringUtils.isNotBlank((String)userGroupType) && (userGroupType.equals(USER_TYPE) || userGroupType.equals(GROUP_TYPE)));
        }
    }

    public static String resolveDefaultEntries(List<String> list) {
        if (list == null || list.isEmpty()) {
            return "[]";
        }
        JSONArray result = new JSONArray();
        for (String l : list) {
            JSONObject obj = new JSONObject();
            obj.element(ID, (Object)l);
            obj.element(LABEL, (Object)l);
            result.add((Object)obj);
        }
        return result.toString();
    }

    public static DocumentModel resolveReference(String property, String value, CoreSession session) {
        if (property != null && !property.isEmpty()) {
            String query = "select * from Document where " + property + "=" + NXQL.escapeString((String)value);
            DocumentModelList docs = session.query(query);
            if (docs.size() > 0) {
                return (DocumentModel)docs.get(0);
            }
            log.warn((Object)("Unable to resolve doc using property " + property + " and value " + value));
            return null;
        }
        Object ref = null;
        ref = value.startsWith(DEFAULT_KEY_SEPARATOR) ? new PathRef(value) : new IdRef(value);
        if (session.exists((DocumentRef)ref)) {
            return session.getDocument((DocumentRef)ref);
        }
        log.warn((Object)("Unable to resolve reference on " + ref));
        return null;
    }
}

