/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.procedures.instances.operation.runner;

import java.util.List;
import java.util.Map;
import org.nuxeo.ecm.automation.core.util.DocumentHelper;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.platform.routing.api.DocumentRoute;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.ecm.platform.task.Task;
import org.osivia.procedures.exception.ProcedureException;
import org.osivia.procedures.utils.ProcedureHelper;

public class UnrestrictedResumeProcedure
extends UnrestrictedSessionRunner {
    private DocumentRoutingService routingService;
    private DocumentModel procedureInstance;
    private Map<String, String> properties;
    private String taskTitle;
    private String taskType;
    private StringList groups;
    private List<String> actors;

    public UnrestrictedResumeProcedure(CoreSession session, DocumentRoutingService routingService, DocumentModel procedureInstance, Map<String, String> properties, List<String> actors) {
        super(session);
        this.routingService = routingService;
        this.procedureInstance = procedureInstance;
        this.actors = actors;
    }

    public void run() throws ClientException {
        this.updateProcedureInstance();
        this.resumeProcedure();
    }

    public void updateProcedureInstance() throws ClientException {
        try {
            DocumentHelper.setProperties((CoreSession)this.session, (DocumentModel)this.procedureInstance, this.properties);
        }
        catch (Exception e) {
            throw new ClientException((Throwable)e);
        }
        this.procedureInstance = this.session.saveDocument(this.procedureInstance);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void resumeProcedure() {
        ProcedureHelper procedureHelper = ProcedureHelper.getInstance();
        DocumentRoute routeInstance = procedureHelper.getProcedureAsRoute(this.session, this.procedureInstance);
        DocumentModel documentRoute = routeInstance.getDocument();
        if (documentRoute == null) throw new ProcedureException("");
        Task currentTask = procedureHelper.getCurrentTask(this.session, documentRoute, this.actors);
        if (currentTask.getDocument() == null) return;
    }
}

