/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.procedures.record.es.customizer.writer.denormalization;

import fr.toutatice.ecm.es.customizer.writers.denormalization.AbstractDenormalizationJsonESWriter;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.BaseJsonNode;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.impl.ListProperty;
import org.nuxeo.ecm.core.schema.utils.DateParser;
import org.osivia.procedures.es.customizer.writer.helper.DenormalizationJsonESWriterHelper;
import org.osivia.procedures.record.model.FieldTypes;
import org.osivia.procedures.record.model.RecordModelAnalyzer;
import org.osivia.procedures.record.model.relation.RelationsModelResolver;
import org.osivia.procedures.record.security.rules.helper.RecordHelper;
import org.osivia.procedures.record.security.rules.helper.RecordsFetcherHelper;

public class RecordJsonESDenormalizationWriter
extends AbstractDenormalizationJsonESWriter {
    private static final String GET_RECORD_TARGET_N_TO_ONE_RELATION_QUERY = "select * from Record where ttc:webid ='%s'  and ecm:isVersion = 0 and ecm:isProxy = 0 and ecm:currentLifeCycleState <> 'deleted' ";
    private static final String GET_LINKED_N_TO_N_ENTITIES_QUERY = "select * from Record where rcd:procedureModelWebId = '%s' and ttc:webid in %s ";

    public boolean accept(DocumentModel doc) {
        return doc != null && "Record".equals(doc.getType());
    }

    protected void denormalizeDoc(JsonGenerator jg, DocumentModel record, String[] schemas, Map<String, String> contextParameters) throws IOException {
        DocumentModel recordModel = this.session.getParentDocument(record.getRef());
        if (recordModel != null) {
            jg.writeStringField("rcd:type", (String)((Object)recordModel.getPropertyValue("ttc:webid")));
        }
        DenormalizationJsonESWriterHelper.mapKeyValue(jg, record, "rcd:globalVariablesValues", "name", "value");
        this.denormalize(jg, recordModel, record, "rcd:globalVariablesValues", "name", "value", schemas, contextParameters);
    }

    public JsonGenerator denormalize(JsonGenerator jg, DocumentModel recordModel, DocumentModel record, String listPropXPath, String entryKey, String entryValue, String[] schemas, Map<String, String> contextParameters) throws JsonGenerationException, IOException {
        ListProperty valuesProp = (ListProperty)record.getProperty(listPropXPath);
        if (CollectionUtils.isNotEmpty((Collection)valuesProp)) {
            jg.writeFieldName("rcd:data");
            jg.writeStartObject();
            for (Property valueProp : valuesProp) {
                String name = (String)((Object)valueProp.get(entryKey).getValue());
                String value = (String)((Object)valueProp.get(entryValue).getValue());
                if (!StringUtils.isNotEmpty((String)name) || !StringUtils.isNotEmpty((String)value)) continue;
                Matcher matcher = DenormalizationJsonESWriterHelper.COMPLEX_PROPERTY_PATTERN.matcher(value);
                if (matcher.matches()) {
                    BaseJsonNode jsonNode;
                    ObjectMapper mapper;
                    String type = RelationsModelResolver.getInstance().getTypeOfSourcesOfNToOneRelation(recordModel, name);
                    if (StringUtils.isNotBlank((String)type)) {
                        DocumentModelList targets = this.getTargetsOfNToNRelation(type, value);
                        if (targets != null) {
                            jg.writeFieldName(name);
                            jg.writeStartArray();
                            for (DocumentModel target : targets) {
                                this.jsonESWriter.writeNativeESDocument(jg, target, target.getSchemas(), null);
                            }
                            jg.writeEndArray();
                            continue;
                        }
                        jg.writeStringField(name, value);
                        continue;
                    }
                    String fieldType = RecordModelAnalyzer.getInstance().getFieldType(recordModel, name);
                    if (this.isAttachedBinary(fieldType)) {
                        value = StringUtils.substringBeforeLast((String)value, (String)"}").concat(",\"type\":\"" + fieldType + "\"}\"");
                        mapper = new ObjectMapper();
                        jsonNode = (BaseJsonNode)mapper.readValue(value, BaseJsonNode.class);
                        jg.writeFieldName(name);
                        jsonNode.serialize(jg, null);
                        continue;
                    }
                    mapper = new ObjectMapper();
                    jsonNode = (BaseJsonNode)mapper.readValue(value, BaseJsonNode.class);
                    jg.writeFieldName(name);
                    jsonNode.serialize(jg, null);
                    continue;
                }
                if (RelationsModelResolver.getInstance().isSourceOfNToOneRelation(recordModel, name)) {
                    DocumentModel targetRecord = this.getTargetOfNToOnefRelation(value);
                    if (targetRecord != null) {
                        jg.writeFieldName(name);
                        this.jsonESWriter.writeNativeESDocument(jg, targetRecord, targetRecord.getSchemas(), null);
                        continue;
                    }
                    jg.writeStringField(name, value);
                    continue;
                }
                if (this.isDate(value)) {
                    jg.writeFieldName(name);
                    String initialValue = value;
                    try {
                        value = DateParser.formatW3CDateTime((Date)DenormalizationJsonESWriterHelper.format.parse(value));
                    }
                    catch (ParseException e) {
                        value = initialValue;
                    }
                    jg.writeString(value);
                    continue;
                }
                jg.writeStringField(name, value);
            }
            jg.writeEndObject();
        }
        return jg;
    }

    private boolean isDate(String value) {
        Matcher dateMatcher = DenormalizationJsonESWriterHelper.DATE_PATTERN.matcher(value);
        return dateMatcher.matches();
    }

    private boolean isAttachedBinary(String fieldType) {
        return ArrayUtils.contains((Object[])FieldTypes.types(), (Object)fieldType);
    }

    private DocumentModelList getTargetsOfNToNRelation(String type, String idsAsString) {
        DocumentModelList targets = null;
        List<String> ids = new ArrayList<String>(0);
        if (CollectionUtils.isNotEmpty(ids = RecordHelper.getIds(ids, idsAsString))) {
            String query = String.format(GET_LINKED_N_TO_N_ENTITIES_QUERY, type, RecordsFetcherHelper.getInOperand(ids));
            targets = this.session.query(query, -1);
        }
        return targets;
    }

    private DocumentModel getTargetOfNToOnefRelation(String id) {
        DocumentModel target = null;
        DocumentModelList targets = this.session.query(String.format(GET_RECORD_TARGET_N_TO_ONE_RELATION_QUERY, id), 1);
        if (targets.size() == 1) {
            target = (DocumentModel)targets.get(0);
        }
        return target;
    }
}

