/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.procedures.record.security.automation;

import fr.toutatice.ecm.platform.automation.RefreshPrincipal;
import java.security.Principal;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.core.api.CoreSession;
import org.osivia.procedures.record.security.rules.SecurityRulesBuilder;

@Operation(id="Document.RefreshPrincipal")
public class RefreshPrincipalSecurity
extends RefreshPrincipal {
    private static final Log log = LogFactory.getLog(RefreshPrincipalSecurity.class);
    @Context
    protected OperationContext ctx;
    @Context
    protected CoreSession session;

    @OperationMethod
    public void run() throws Exception {
        this.initInheritedContexts();
        super.run();
        Principal principal = this.ctx.getPrincipal();
        if (principal != null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("[Refreshing Security] for: " + principal.getName()));
            }
            SecurityRulesBuilder rulesBuilder = SecurityRulesBuilder.getInstance();
            rulesBuilder.invalidateRulesOf(principal.getName());
            rulesBuilder.buildSecurityRelations(this.session, principal);
        }
    }

    protected void initInheritedContexts() {
        ((RefreshPrincipal)this).ctx = this.ctx;
    }
}

