/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.procedures.record.security.rules.helper;

import java.util.Iterator;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.model.impl.ListProperty;
import org.nuxeo.ecm.core.api.model.impl.MapProperty;
import org.osivia.procedures.record.security.rules.model.type.Entity;

public class RecordModelHelper {
    public static final String RECORD_MODELS_QUERY = "select * from RecordFolder where " + StringUtils.substringAfter((String)" and ecm:isVersion = 0 and ecm:isProxy = 0 and ecm:currentLifeCycleState <> 'deleted' ", (String)" and");

    private RecordModelHelper() {
    }

    public static ListProperty getFieldsDefinitions(DocumentModel recordModel) {
        return (ListProperty)recordModel.getProperty("pcd:globalVariablesDefinitions");
    }

    public static String getModelType(MapProperty relationProperty) {
        String webId;
        String value = (String)((Object)relationProperty.get("varOptions").getValue());
        try {
            JSONObject object = JSONObject.fromObject((Object)value);
            webId = object.getString("recordFolderWebId");
        }
        catch (JSONException e) {
            webId = null;
        }
        return webId;
    }

    public static String getType(DocumentModel model) {
        return (String)model.getProperty("ttc:webid").getValue(String.class);
    }

    public static DocumentModel getModelOf(DocumentModelList models, Entity entity) {
        DocumentModel modelOfEntity = null;
        Iterator iterator = models.iterator();
        while (iterator.hasNext() && modelOfEntity == null) {
            DocumentModel model = (DocumentModel)iterator.next();
            String modelType = (String)model.getProperty("ttc:webid").getValue(String.class);
            if (!StringUtils.equals((String)entity.getType(), (String)modelType)) continue;
            modelOfEntity = model;
        }
        return modelOfEntity;
    }
}

