/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.procedures.record.security.rules.model;

import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.osivia.procedures.record.security.rules.model.SecurityRelationType;
import org.osivia.procedures.record.security.rules.model.type.Entity;

public class SecurityRelation {
    private SecurityRelationType type;
    private String relationKey;
    private Entity entity;
    private String recordType;
    private List<String> recordsIds;

    public SecurityRelation(SecurityRelationType type) {
        this.type = type;
    }

    public SecurityRelation() {
    }

    public SecurityRelationType getType() {
        return this.type;
    }

    public void setType(SecurityRelationType type) {
        this.type = type;
    }

    public String getRelationKey() {
        return this.relationKey;
    }

    public void setRelationKey(String relationKey) {
        this.relationKey = relationKey;
    }

    public String getRecordType() {
        return this.recordType;
    }

    public void setRecordType(String recordType) {
        this.recordType = recordType;
    }

    public List<String> getRecordsIds() {
        return this.recordsIds;
    }

    public void setRecordsIds(List<String> recordsIds) {
        this.recordsIds = recordsIds;
    }

    public Entity getEntity() {
        return this.entity;
    }

    public void setEntity(CoreSession session, Entity entity) {
        this.entity = entity;
        if (this.recordType == null) {
            this.recordType = entity.getType();
        }
        if (this.recordsIds == null) {
            List<DocumentModel> records = entity.getRecords();
            if (CollectionUtils.isNotEmpty(records)) {
                this.recordsIds = new ArrayList<String>(records.size());
            }
            for (DocumentModel record : records) {
                String id = (String)((Object)ToutaticeDocumentHelper.getUnrestrictedProperty((CoreSession)session, (String)record.getId(), (String)"ttc:webid"));
                this.recordsIds.add(id);
            }
        }
    }

    public boolean equals(Object other) {
        boolean equals = false;
        if (other != null && other instanceof SecurityRelation) {
            SecurityRelation otherSr = (SecurityRelation)other;
            return StringUtils.equals((String)this.recordType, (String)otherSr.getRecordType());
        }
        return equals;
    }
}

