/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.procedures.record.security.rules.model.relation;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.osivia.procedures.record.security.rules.model.relation.RelationModel;
import org.osivia.procedures.record.security.rules.model.relation.RelationModelType;
import org.osivia.procedures.record.security.rules.model.type.Entity;

public class RecordsRelation {
    private RelationModel relationModel;
    private Entity sourceEntity;
    private Entity targetEntity;
    private List<String> sourceIds;
    private List<String> targetIds;

    public RecordsRelation() {
    }

    public RecordsRelation(RelationModel relationModel) {
        this.relationModel = relationModel;
        this.sourceIds = new ArrayList<String>(0);
        this.targetIds = new ArrayList<String>(0);
    }

    public RelationModelType getType() {
        return this.relationModel.getType();
    }

    public String getSourceType() {
        return this.relationModel.getSourceType();
    }

    public String getTargetKey() {
        return this.relationModel.getTargetKey();
    }

    public String getTargetType() {
        return this.relationModel.getTargetType();
    }

    public RelationModel getRelationModel() {
        return this.relationModel;
    }

    public void setRelationModel(RelationModel relationModel) {
        this.relationModel = relationModel;
    }

    public void addSourceId(String id) {
        if (!this.sourceIds.contains(id)) {
            this.sourceIds.add(id);
        }
    }

    public List<String> getSourceIds() {
        return this.sourceIds;
    }

    public void setSourceIds(List<String> sourceIds) {
        this.sourceIds = sourceIds;
    }

    public void addTargetId(String id) {
        if (!this.targetIds.contains(id)) {
            this.targetIds.add(id);
        }
    }

    public List<String> getTargetIds() {
        return this.targetIds;
    }

    public void setTargetIds(List<String> targetIds) {
        this.targetIds = targetIds;
    }

    public Entity getSourceEntity() {
        return this.sourceEntity;
    }

    public void setSourceEntity(Entity sourceEntity) {
        this.sourceEntity = sourceEntity;
    }

    public Entity getTargetEntity() {
        return this.targetEntity;
    }

    public void setTargetEntity(Entity targetEntity) {
        this.targetEntity = targetEntity;
    }

    public boolean equals(Object other) {
        boolean equals = false;
        if (other != null && other instanceof RecordsRelation) {
            RecordsRelation otherRelation = (RecordsRelation)other;
            equals = StringUtils.equals((String)this.getSourceType(), (String)otherRelation.getSourceType()) && StringUtils.equals((String)this.getTargetType(), (String)otherRelation.getTargetType()) && this.getType().equals((Object)otherRelation.getType());
        }
        return equals;
    }

    public int hashCode() {
        return (this.getSourceType() + "-" + this.getTargetType()).hashCode();
    }
}

