/*
 * Decompiled with CFR 0.152.
 */
package org.osivia.procedures.utils;

import fr.toutatice.ecm.platform.core.helper.ToutaticeWorkflowHelper;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.ArrayUtils;
import org.nuxeo.ecm.automation.core.util.StringList;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoGroup;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.platform.routing.api.DocumentRoute;
import org.nuxeo.ecm.platform.usermanager.UserManager;
import org.nuxeo.runtime.api.Framework;

public class UsersHelper {
    private static UserManager userManager = (UserManager)Framework.getService(UserManager.class);

    private UsersHelper() {
    }

    public static String[] getUsersOfGroup(String[] names) {
        Object[] users = new String[]{};
        if (names != null && names.length > 0) {
            for (String name : names) {
                List memberUsers;
                NuxeoGroup group = userManager.getGroup(name);
                if (group == null || !CollectionUtils.isNotEmpty((Collection)(memberUsers = group.getMemberUsers()))) continue;
                users = (String[])ArrayUtils.addAll((Object[])users, (Object[])memberUsers.toArray(new String[memberUsers.size()]));
            }
        }
        return users;
    }

    public static String[] getUsersOfGroup(StringList names) {
        Object[] users = new String[]{};
        for (String name : names) {
            List memberUsers;
            NuxeoGroup group = userManager.getGroup(name);
            if (group == null || !CollectionUtils.isNotEmpty((Collection)(memberUsers = group.getMemberUsers()))) continue;
            users = (String[])ArrayUtils.addAll((Object[])users, (Object[])memberUsers.toArray(new String[memberUsers.size()]));
        }
        return users;
    }

    public static String getInitiator(DocumentModel pi) {
        String initiator = "";
        DocumentRoute genericWf = ToutaticeWorkflowHelper.getWorkflowByName((String)"generic-model", (DocumentModel)pi);
        if (genericWf != null) {
            initiator = (String)((Object)genericWf.getDocument().getPropertyValue("docri:initiator"));
        }
        return initiator;
    }

    public static String getUsername(String login) {
        NuxeoPrincipal principal = userManager.getPrincipal(login);
        String firstName = principal.getFirstName();
        String lastName = principal.getLastName();
        return firstName + " " + lastName;
    }
}

