/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.nuxeo.common.xmap.annotation.XNode;
import org.nuxeo.common.xmap.annotation.XNodeList;
import org.nuxeo.common.xmap.annotation.XObject;
import org.nuxeo.ecm.core.api.security.UserVisiblePermission;
import org.nuxeo.ecm.core.security.PermissionUIItemComparator;
import org.nuxeo.ecm.core.security.PermissionUIItemDescriptor;

@XObject(value="visibility")
public class PermissionVisibilityDescriptor {
    @XNode(value="@type")
    private String typeName = "";
    private final List<PermissionUIItemDescriptor> items = new ArrayList<PermissionUIItemDescriptor>();
    private String[] sortedPermissionNames;

    public PermissionVisibilityDescriptor() {
    }

    public PermissionVisibilityDescriptor(PermissionVisibilityDescriptor pvd) {
        this.typeName = pvd.typeName;
        for (PermissionUIItemDescriptor pid : pvd.items) {
            this.items.add(new PermissionUIItemDescriptor(pid));
        }
    }

    @XNodeList(value="item", type=PermissionUIItemDescriptor[].class, componentType=PermissionUIItemDescriptor.class)
    protected void setPermissionUIItems(PermissionUIItemDescriptor[] items) {
        this.items.clear();
        this.items.addAll(Arrays.asList(items));
        this.sortedPermissionNames = null;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public List<PermissionUIItemDescriptor> getPermissionUIItems() {
        return this.items;
    }

    public void merge(PermissionVisibilityDescriptor other) throws Exception {
        ArrayList<PermissionUIItemDescriptor> otherItems = new ArrayList<PermissionUIItemDescriptor>(other.items);
        LinkedList<PermissionUIItemDescriptor> mergedItems = new LinkedList<PermissionUIItemDescriptor>();
        for (PermissionUIItemDescriptor item : this.items) {
            for (PermissionUIItemDescriptor otherItem : otherItems) {
                if (!item.getPermission().equals(otherItem.getPermission())) continue;
                item.merge(otherItem);
                mergedItems.add(otherItem);
            }
            otherItems.removeAll(mergedItems);
            mergedItems.clear();
        }
        this.items.addAll(otherItems);
        this.sortedPermissionNames = null;
    }

    public String[] getSortedItems() {
        if (this.sortedPermissionNames == null) {
            Collections.sort(this.items, new PermissionUIItemComparator());
            LinkedList<String> filteredPermissions = new LinkedList<String>();
            for (PermissionUIItemDescriptor pid : this.items) {
                if (!pid.isShown()) continue;
                filteredPermissions.add(pid.getPermission());
            }
            this.sortedPermissionNames = filteredPermissions.toArray(new String[filteredPermissions.size()]);
        }
        return this.sortedPermissionNames;
    }

    public List<UserVisiblePermission> getSortedUIPermissionDescriptor() {
        Collections.sort(this.items, new PermissionUIItemComparator());
        ArrayList<UserVisiblePermission> result = new ArrayList<UserVisiblePermission>();
        for (PermissionUIItemDescriptor pid : this.items) {
            if (!pid.isShown()) continue;
            result.add(new UserVisiblePermission(pid.getId(), pid.getPermission(), pid.getDenyPermission()));
        }
        return result;
    }

    public boolean equals(Object other) {
        if (other instanceof PermissionVisibilityDescriptor) {
            PermissionVisibilityDescriptor otherPvd = (PermissionVisibilityDescriptor)other;
            if (!this.typeName.equals(otherPvd.typeName)) {
                return false;
            }
            return this.items.equals(otherPvd.items);
        }
        return false;
    }

    public String toString() {
        return String.format("PermissionVisibilityDescriptor[%s]", this.typeName);
    }
}

