/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import java.io.Serializable;
import java.util.Arrays;
import org.nuxeo.ecm.core.storage.StorageException;
import org.nuxeo.ecm.core.storage.sql.Fragment;
import org.nuxeo.ecm.core.storage.sql.PersistenceContext;
import org.nuxeo.ecm.core.storage.sql.Row;
import org.nuxeo.ecm.core.storage.sql.RowMapper;

public class CollectionFragment
extends Fragment {
    private static final long serialVersionUID = 1L;

    public CollectionFragment(Row row, Fragment.State state, PersistenceContext context) {
        super(row, state, context);
    }

    public void set(Serializable[] value) throws StorageException {
        if (this.getState() != Fragment.State.INVALIDATED_MODIFIED && Arrays.equals(this.row.values, value)) {
            return;
        }
        this.row.values = (Serializable[])value.clone();
        this.markModified();
    }

    public Serializable[] get() throws StorageException {
        this.accessed();
        return (Serializable[])this.row.values.clone();
    }

    public boolean isDirty() {
        return !Arrays.equals(this.row.values, this.oldvalues);
    }

    @Override
    public RowMapper.RowUpdate getRowUpdate() {
        if (Arrays.equals(this.row.values, this.oldvalues)) {
            return null;
        }
        if (this.oldvalues == null) {
            return new RowMapper.RowUpdate(this.row, 0);
        }
        if (this.row.values != null && CollectionFragment.isPrefix(this.oldvalues, this.row.values)) {
            return new RowMapper.RowUpdate(this.row, this.oldvalues.length);
        }
        return new RowMapper.RowUpdate(this.row);
    }

    public static boolean isPrefix(Serializable[] left, Serializable[] right) {
        if (left.length >= right.length) {
            return false;
        }
        for (int i = 0; i < left.length; ++i) {
            Serializable o1 = left[i];
            Serializable o2 = right[i];
            if (o1 != null ? o1.equals(o2) : o2 == null) continue;
            return false;
        }
        return true;
    }

    @Override
    protected Fragment.State refetch() throws StorageException {
        this.row.values = this.context.mapper.readCollectionRowArray(this.row);
        this.clearDirty();
        return Fragment.State.PRISTINE;
    }

    @Override
    protected Fragment.State refetchDeleted() throws StorageException {
        this.row.values = this.context.model.getCollectionFragmentType(this.row.tableName).getEmptyArray();
        this.clearDirty();
        return Fragment.State.PRISTINE;
    }
}

