/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.oauth2.tokens;

import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.auth.oauth2.CredentialStore;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.mutable.MutableObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.platform.oauth2.tokens.NuxeoOAuth2Token;
import org.nuxeo.runtime.api.Framework;

public class OAuth2TokenStore
implements CredentialStore {
    protected static final Log log = LogFactory.getLog(OAuth2TokenStore.class);
    public static final String DIRECTORY_NAME = "oauth2Tokens";
    private String serviceName;

    public OAuth2TokenStore(String serviceName) {
        this.serviceName = serviceName;
    }

    public void store(String userId, Credential credential) {
        this.store(userId, new NuxeoOAuth2Token(credential));
    }

    public void store(String userId, NuxeoOAuth2Token token) {
        token.setServiceName(this.serviceName);
        token.setNuxeoLogin(userId);
        try {
            this.storeTokenAsDirectoryEntry(token);
        }
        catch (Exception e) {
            log.error((Object)"Error during token storage", (Throwable)e);
        }
    }

    public NuxeoOAuth2Token refresh(String refreshToken, String clientId) throws ClientException {
        HashMap<String, Serializable> filter = new HashMap<String, Serializable>();
        filter.put("clientId", (Serializable)((Object)clientId));
        filter.put("refreshToken", (Serializable)((Object)refreshToken));
        filter.put("serviceName", (Serializable)((Object)this.serviceName));
        NuxeoOAuth2Token token = this.getToken(filter);
        if (token != null) {
            this.delete(token.getAccessToken(), clientId);
            token.refresh();
            return this.storeTokenAsDirectoryEntry(token);
        }
        return null;
    }

    public void delete(String token, String clientId) throws ClientException {
        final String fToken = token;
        final String fClientId = clientId;
        Framework.doPrivileged((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DirectoryService ds = (DirectoryService)Framework.getLocalService(DirectoryService.class);
                try (Session session = null;){
                    session = ds.open(OAuth2TokenStore.DIRECTORY_NAME);
                    HashMap<String, String> filter = new HashMap<String, String>();
                    filter.put("serviceName", OAuth2TokenStore.this.serviceName);
                    filter.put("clientId", fClientId);
                    filter.put("accessToken", fToken);
                    DocumentModelList entries = session.query(filter);
                    for (DocumentModel entry : entries) {
                        session.deleteEntry(entry);
                    }
                }
            }
        });
    }

    public void delete(String userId, Credential credential) {
    }

    public boolean load(String userName, Credential credential) {
        try {
            NuxeoOAuth2Token token = this.getToken(this.serviceName, userName);
            credential.setAccessToken(token.getAccessToken());
            credential.setRefreshToken(token.getRefreshToken());
            credential.setExpirationTimeMilliseconds(token.getExpirationTimeMilliseconds());
            return true;
        }
        catch (Exception e) {
            log.error((Object)"Error during token loading", (Throwable)e);
            return false;
        }
    }

    public NuxeoOAuth2Token getToken(String token) throws ClientException {
        final MutableObject mo = new MutableObject();
        final String fToken = token;
        Framework.doPrivileged((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DirectoryService ds = (DirectoryService)Framework.getLocalService(DirectoryService.class);
                try (Session session = null;){
                    session = ds.open(OAuth2TokenStore.DIRECTORY_NAME);
                    HashMap<String, String> filter = new HashMap<String, String>();
                    filter.put("serviceName", OAuth2TokenStore.this.serviceName);
                    filter.put("accessToken", fToken);
                    DocumentModelList entries = session.query(filter);
                    if (entries.size() == 0) {
                        mo.setValue(null);
                    }
                    if (entries.size() > 1) {
                        log.error((Object)"Found several tokens");
                    }
                    mo.setValue((Object)OAuth2TokenStore.this.getTokenFromDirectoryEntry((DocumentModel)entries.get(0)));
                }
            }
        });
        return (NuxeoOAuth2Token)mo.getValue();
    }

    protected NuxeoOAuth2Token getToken(Map<String, Serializable> aFilter) throws ClientException {
        final MutableObject mo = new MutableObject();
        final Map<String, Serializable> filter = aFilter;
        Framework.doPrivileged((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DirectoryService ds = (DirectoryService)Framework.getLocalService(DirectoryService.class);
                try (Session session = null;){
                    session = ds.open(OAuth2TokenStore.DIRECTORY_NAME);
                    DocumentModelList entries = session.query(filter);
                    if (entries.size() == 0) {
                        mo.setValue(null);
                    }
                    if (entries.size() > 1) {
                        log.error((Object)"Found several tokens");
                    }
                    mo.setValue((Object)OAuth2TokenStore.this.getTokenFromDirectoryEntry((DocumentModel)entries.get(0)));
                }
            }
        });
        return (NuxeoOAuth2Token)mo.getValue();
    }

    public NuxeoOAuth2Token getToken(String serviceName, String nuxeoLogin) throws ClientException {
        HashMap<String, Serializable> filter = new HashMap<String, Serializable>();
        filter.put("serviceName", (Serializable)((Object)serviceName));
        filter.put("nuxeoLogin", (Serializable)((Object)nuxeoLogin));
        return this.getToken(filter);
    }

    protected NuxeoOAuth2Token getTokenFromDirectoryEntry(DocumentModel entry) throws ClientException {
        return new NuxeoOAuth2Token(entry);
    }

    protected NuxeoOAuth2Token storeTokenAsDirectoryEntry(NuxeoOAuth2Token aToken) throws ClientException {
        final MutableObject mo = new MutableObject();
        final NuxeoOAuth2Token token = aToken;
        Framework.doPrivileged((Runnable)new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                DirectoryService ds = (DirectoryService)Framework.getLocalService(DirectoryService.class);
                try (Session session = null;){
                    session = ds.open(OAuth2TokenStore.DIRECTORY_NAME);
                    DocumentModel entry = session.createEntry(token.toMap());
                    mo.setValue((Object)OAuth2TokenStore.this.getTokenFromDirectoryEntry(entry));
                }
            }
        });
        return (NuxeoOAuth2Token)mo.getValue();
    }
}

