/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.service.security;

import fr.toutatice.ecm.platform.service.security.DocumentSecurityInformationsProvider;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.platform.types.TypeManager;
import org.nuxeo.runtime.api.Framework;

public class DocumentSecurityInformationsProviderImpl
implements DocumentSecurityInformationsProvider {
    private static TypeManager typeMgr = null;

    public static TypeManager getTypeManager() {
        if (typeMgr == null) {
            typeMgr = (TypeManager)Framework.getService(TypeManager.class);
        }
        return typeMgr;
    }

    public Map<String, Object> fetchInfos(CoreSession coreSession, DocumentModel currentDoc) throws ClientException {
        HashMap<String, Object> securityInfo = new HashMap<String, Object>();
        securityInfo.put(DocumentSecurityInformationsProvider.TestedActions.canCopy.name(), this.canCopy(coreSession, currentDoc));
        return securityInfo;
    }

    @Override
    public boolean canCopy(CoreSession coreSession, DocumentModel currentDoc) {
        boolean canCopy = false;
        DocumentRef parentRef = coreSession.getParentDocumentRef(currentDoc.getRef());
        if (parentRef != null) {
            boolean isAdmin = coreSession.hasPermission(currentDoc.getRef(), "Everything");
            if (isAdmin) {
                return true;
            }
            boolean canAdd = coreSession.hasPermission(parentRef, "AddChildren");
            if (canAdd) {
                if (currentDoc.isFolder()) {
                    Collection subTypes = DocumentSecurityInformationsProviderImpl.getTypeManager().getAllowedSubTypes(currentDoc.getType(), currentDoc);
                    canCopy = CollectionUtils.isNotEmpty((Collection)subTypes);
                } else {
                    canCopy = true;
                }
            }
        }
        return canCopy;
    }

    @Override
    public boolean canCopyTo(CoreSession coreSession, DocumentModel currentDocument, DocumentModel target) {
        return false;
    }
}

