/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.service.webid;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.DocumentException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.platform.uidgen.UIDGenerator;
import org.nuxeo.ecm.platform.uidgen.UIDSequencer;
import org.nuxeo.ecm.platform.uidgen.service.UIDGeneratorDescriptor;
import org.nuxeo.ecm.platform.uidgen.service.UIDSequencerImpl;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.model.ComponentContext;
import org.nuxeo.runtime.model.DefaultComponent;
import org.nuxeo.runtime.model.Extension;

public class TTCUIDGeneratorService
extends DefaultComponent {
    public static final String ID = "fr.toutatice.ecm.platform.service.webid.TTCUIDGeneratorService";
    public static final String UID_GENERATORS_EXTENSION_POINT = "generators";
    private static final Log log = LogFactory.getLog(TTCUIDGeneratorService.class);
    private final Map<String, UIDGenerator> generators = new HashMap<String, UIDGenerator>();

    public void activate(ComponentContext context) throws Exception {
        super.activate(context);
    }

    public void deactivate(ComponentContext context) throws Exception {
        super.deactivate(context);
        UIDSequencerImpl.dispose();
    }

    public void registerExtension(Extension extension) throws Exception {
        log.debug((Object)"<registerExtension>");
        super.registerExtension(extension);
        String extPoint = extension.getExtensionPoint();
        if (UID_GENERATORS_EXTENSION_POINT.equals(extPoint)) {
            log.info((Object)"register contributions for extension point: generators");
            Object[] contribs = extension.getContributions();
            this.registerGenerators(extension, contribs);
        } else {
            log.warn((Object)("extension not handled: " + extPoint));
        }
    }

    public UIDSequencer getSequencer() {
        try {
            return (UIDSequencer)Framework.getService(UIDSequencer.class);
        }
        catch (Exception e) {
            throw new RuntimeException("Service is not available.");
        }
    }

    private void registerGenerators(Extension extension, Object[] contribs) throws InstantiationException, IllegalAccessException, ClassNotFoundException {
        for (Object contrib : contribs) {
            UIDGeneratorDescriptor generatorDescriptor = (UIDGeneratorDescriptor)contrib;
            String generatorName = generatorDescriptor.getName();
            UIDGenerator generator = (UIDGenerator)extension.getContext().loadClass(generatorDescriptor.getClassName()).newInstance();
            String[] propNames = generatorDescriptor.getPropertyNames();
            if (propNames.length == 0) {
                log.error((Object)("no property name defined on generator " + generatorName));
            }
            generator.setPropertyNames(propNames);
            String[] docTypes = generatorDescriptor.getDocTypes();
            this.registerGeneratorForDocTypes(generator, docTypes);
            log.info((Object)("registered UID generator: " + generatorName));
        }
    }

    private void registerGeneratorForDocTypes(UIDGenerator generator, String[] docTypes) {
        for (String docType : docTypes) {
            UIDGenerator previous = this.generators.put(docType, generator);
            if (previous != null) {
                log.info((Object)("Overwriting generator: " + previous.getClass() + " for docType: " + docType));
            }
            log.info((Object)("Registered generator: " + generator.getClass() + " for docType: " + docType));
        }
    }

    public void unregisterExtension(Extension extension) throws Exception {
        log.debug((Object)"<unregisterExtension>");
        super.unregisterExtension(extension);
    }

    public UIDGenerator getUIDGeneratorFor(DocumentModel doc) {
        String docTypeName = doc.getType();
        UIDGenerator generator = this.generators.get(docTypeName);
        if (generator == null) {
            log.debug((Object)("No UID Generator defined for doc type: " + docTypeName));
            return null;
        }
        generator.setSequencer(this.getSequencer());
        return generator;
    }

    public UIDGenerator getDefaultUIDGenerator() {
        UIDGenerator generator = this.generators.get("*");
        if (generator == null) {
            log.debug((Object)"No default UID Generator defined");
            return null;
        }
        generator.setSequencer(this.getSequencer());
        return generator;
    }

    public void setUID(DocumentModel doc) throws DocumentException {
        UIDGenerator generator = this.getUIDGeneratorFor(doc);
        if (generator != null) {
            generator.setUID(doc);
        }
        if ((generator = this.getDefaultUIDGenerator()) != null) {
            generator.setUID(doc);
        }
    }

    public String createUID(DocumentModel doc) throws DocumentException {
        UIDGenerator generator = this.getUIDGeneratorFor(doc);
        if (generator == null) {
            return null;
        }
        return generator.createUID(doc);
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (UIDSequencer.class.isAssignableFrom(adapter)) {
            return adapter.cast(new UIDSequencerImpl());
        }
        return null;
    }
}

