/*
 * Decompiled with CFR 0.152.
 */
package fr.index.cloud.ens.virusscan;

import fr.index.cloud.ens.virusscan.ScanChecker;
import fr.index.cloud.ens.virusscan.ScanResult;
import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.core.annotations.Context;
import org.nuxeo.ecm.automation.core.annotations.Operation;
import org.nuxeo.ecm.automation.core.annotations.OperationMethod;
import org.nuxeo.ecm.automation.core.annotations.Param;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.PathRef;
import org.nuxeo.ecm.core.api.impl.blob.StringBlob;

@Operation(id="Index.ScanVirus", category="Document", label="Scan virus", description="Checks  if the file blob contains a virus using the ICAP protocole. Returns false if the file contains a virus, true otherwise")
public class VirusScanOperation {
    public static final String ID = "Index.ScanVirus";
    public static final long OPERATION_TIMEOUT = 180L;
    private static final Log log = LogFactory.getLog(VirusScanOperation.class);
    @Context
    protected CoreSession session;
    @Param(name="path", required=true)
    protected String path;

    @OperationMethod
    public Object run() throws Exception {
        int errorCode;
        JSONArray rowInfosPubli = new JSONArray();
        JSONObject infos = new JSONObject();
        DocumentModel doc = null;
        try {
            PathRef docRef = new PathRef(this.path);
            doc = this.session.getDocument((DocumentRef)docRef);
            ScanResult res = ScanChecker.getInstance().checkFile(doc, this.session, true, 180L);
            errorCode = res.getErrorCode();
            if (res.isModified()) {
                ToutaticeDocumentHelper.saveDocumentSilently((CoreSession)this.session, (DocumentModel)doc, (boolean)true);
            }
        }
        catch (ClientException ce) {
            errorCode = 2;
            log.warn((Object)("Failed to scan document with path  '" + this.path + "', error:" + ce.getMessage()));
        }
        infos.element("error", errorCode);
        rowInfosPubli.add((Object)infos);
        return this.createBlob(rowInfosPubli);
    }

    private Blob createBlob(JSONArray json) {
        return new StringBlob(json.toString(), "application/json");
    }
}

