/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.automation.core.operations.business.adapter;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.annotate.JsonIgnore;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.annotate.JsonPropertyOrder;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.impl.SimpleDocumentModel;

@JsonPropertyOrder(value={"type", "id"})
public abstract class BusinessAdapter {
    private static final Log log = LogFactory.getLog(BusinessAdapter.class);
    @JsonProperty(value="id")
    protected String id;
    @JsonProperty(value="type")
    protected String type;
    protected transient DocumentModel doc;

    public BusinessAdapter() {
        this.doc = new SimpleDocumentModel();
    }

    public BusinessAdapter(DocumentModel document) {
        this.type = document.getType();
        this.doc = document;
        this.id = this.doc.getId();
    }

    public void save(CoreSession session) {
        try {
            session.saveDocument(this.doc);
        }
        catch (ClientException e) {
            log.error((Object)"Cannot save document", (Throwable)e);
        }
    }

    @JsonIgnore
    public DocumentModel getDocument() {
        return this.doc;
    }

    public String getId() {
        try {
            return this.doc.getId();
        }
        catch (UnsupportedOperationException e) {
            return this.id;
        }
    }

    public String getType() {
        return this.doc.getType() == null ? this.type : this.doc.getType();
    }
}

