/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.directory;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.directory.Directory;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.runtime.api.Framework;
import org.nuxeo.runtime.services.event.Event;
import org.nuxeo.runtime.services.event.EventListener;

public class DirectoryCacheFlusher
implements EventListener {
    private static final Log log = LogFactory.getLog(DirectoryCacheFlusher.class);

    public boolean aboutToHandleEvent(Event event) {
        return false;
    }

    public void handleEvent(Event event) {
        if (!Framework.isDevModeSet()) {
            log.info((Object)"Do not flush the directory caches: dev mode is not set");
            return;
        }
        if (!"flush".equals(event.getId())) {
            return;
        }
        try {
            DirectoryService service = (DirectoryService)Framework.getLocalService(DirectoryService.class);
            List directories = service.getDirectories();
            if (directories != null) {
                for (Directory directory : directories) {
                    directory.getCache().invalidateAll();
                }
            }
        }
        catch (Exception e) {
            log.error((Object)"Error while flushing the directory caches", (Throwable)e);
        }
    }
}

