/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.core.helper;

import fr.toutatice.ecm.platform.core.query.helper.ToutaticeEsQueryHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.model.PropertyException;
import org.nuxeo.ecm.platform.routing.api.DocumentRoute;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.platform.task.core.service.DocumentTaskProvider;
import org.nuxeo.ecm.platform.task.core.service.TaskEventNotificationHelper;
import org.nuxeo.runtime.api.Framework;

public final class ToutaticeWorkflowHelper {
    public static final String GET_TASKS_BY_NAME_PROVIDER = "GET_TASKS_BY_NAME_FOR_TARGET_DOCUMENT";
    public static final String GET_WF_BY_NAME_QUERY = "select * from DocumentRoute where dc:title = '%s' and docri:participatingDocuments = '%s' and ecm:currentLifeCycleState IN ('ready','running') order by dc:created";
    public static final String GET_WF_ON_DOCUMENT_QUERY = "select * from DocumentRoute where docri:participatingDocuments = '%s' and ecm:currentLifeCycleState IN ('ready','running') order by dc:created";

    private ToutaticeWorkflowHelper() {
    }

    public static List<DocumentRoute> getWorkflowsOnDocument(DocumentModel currentDoc) {
        ArrayList<DocumentRoute> routes = new ArrayList<DocumentRoute>(1);
        CoreSession session = currentDoc.getCoreSession();
        String nxql = String.format(GET_WF_ON_DOCUMENT_QUERY, currentDoc.getId());
        DocumentModelList wfs = ToutaticeEsQueryHelper.query(session, nxql);
        if (CollectionUtils.isNotEmpty((Collection)wfs)) {
            for (DocumentModel wf : wfs) {
                routes.add((DocumentRoute)wf.getAdapter(DocumentRoute.class));
            }
        }
        return routes;
    }

    public static Task getTaskByName(String taskName, CoreSession session, DocumentModel currentDoc) throws ClientException {
        Task searchedTask = null;
        Object[] params = new Object[]{taskName, currentDoc.getId()};
        List tasks = DocumentTaskProvider.getTasks((String)GET_TASKS_BY_NAME_PROVIDER, (CoreSession)session, (boolean)true, null, (Object[])params);
        if (CollectionUtils.isNotEmpty((Collection)tasks)) {
            searchedTask = (Task)tasks.get(0);
        }
        return searchedTask;
    }

    public static boolean isTaskPending(String taskName, CoreSession session, DocumentModel currentDoc) {
        boolean isPending = false;
        Task taskByName = ToutaticeWorkflowHelper.getTaskByName(taskName, session, currentDoc);
        if (taskByName != null) {
            isPending = taskByName.isOpened();
        }
        return isPending;
    }

    public static DocumentRoute getWorkflowByName(String workflowName, DocumentModel currentDoc) {
        DocumentRoute searchedWf = null;
        CoreSession session = currentDoc.getCoreSession();
        String nxql = String.format(GET_WF_BY_NAME_QUERY, workflowName, currentDoc.getId());
        DocumentModelList wfs = ToutaticeEsQueryHelper.query(session, nxql);
        if (CollectionUtils.isNotEmpty((Collection)wfs)) {
            DocumentModel wf = (DocumentModel)wfs.get(0);
            searchedWf = (DocumentRoute)wf.getAdapter(DocumentRoute.class);
        }
        return searchedWf;
    }

    public static void notifyRecipients(CoreSession documentManager, Task task, DocumentModel document, String initiator, String event) throws ClientException {
        NuxeoPrincipal principal = (NuxeoPrincipal)documentManager.getPrincipal();
        HashMap<String, String[]> eventProperties = new HashMap<String, String[]>();
        ArrayList<String> notificationRecipients = new ArrayList<String>();
        if (initiator != null) {
            notificationRecipients.add(initiator);
        }
        notificationRecipients.addAll(task.getActors());
        eventProperties.put("recipients", notificationRecipients.toArray(new String[notificationRecipients.size()]));
        TaskEventNotificationHelper.notifyEvent((CoreSession)documentManager, (DocumentModel)document, (NuxeoPrincipal)principal, (Task)task, (String)event, eventProperties, null, null);
    }

    public static DocumentRoute getOnLineWorkflow(DocumentModel currentDoc) {
        return ToutaticeWorkflowHelper.getWorkflowByName("toutatice_online_approbation", currentDoc);
    }

    public static boolean isOnLineWorkflow(DocumentModel currentDoc) {
        return ToutaticeWorkflowHelper.getOnLineWorkflow(currentDoc) != null;
    }

    public static String getOnLineWorkflowInitiator(DocumentModel currentDoc) throws PropertyException, ClientException {
        String initiator = "";
        DocumentRoute route = ToutaticeWorkflowHelper.getOnLineWorkflow(currentDoc);
        if (route != null) {
            initiator = (String)((Object)route.getDocument().getPropertyValue("docri:initiator"));
        }
        return initiator;
    }

    public static String getCurrentWorkflowInitiator(DocumentModel currentDoc) {
        String initiator = "";
        DocumentRoutingService routing = (DocumentRoutingService)Framework.getService(DocumentRoutingService.class);
        currentDoc.getSessionId();
        List documentRoutesForAttachedDocument = routing.getDocumentRoutesForAttachedDocument(currentDoc.getCoreSession(), currentDoc.getId());
        if (CollectionUtils.isNotEmpty((Collection)documentRoutesForAttachedDocument)) {
            DocumentModel documentModel = ((DocumentRoute)documentRoutesForAttachedDocument.get(0)).getDocument();
            initiator = (String)((Object)documentModel.getPropertyValue("docri:initiator"));
        }
        return initiator;
    }
}

