/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.core.listener;

import fr.toutatice.ecm.platform.core.helper.ToutaticeDocumentHelper;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;

public class BlobSynchronisationListener
implements EventListener {
    public void handleEvent(Event event) throws ClientException {
        if (event.getContext() instanceof DocumentEventContext) {
            String title;
            Blob blob;
            DocumentEventContext ctx = (DocumentEventContext)event.getContext();
            CoreSession session = ctx.getCoreSession();
            DocumentModel document = ctx.getSourceDocument();
            if (document.hasSchema("file") && (blob = (Blob)document.getPropertyValue("file:content")) != null && StringUtils.isNotEmpty((String)(title = (String)((Object)document.getPropertyValue("dc:title")))) && !StringUtils.equalsIgnoreCase((String)blob.getFilename(), (String)title)) {
                Property p = document.getProperty("file:content");
                Serializable o = p.getValue();
                if (o instanceof Blob) {
                    Blob newBlob = (Blob)o;
                    newBlob.setFilename(title);
                    p.setValue((Object)newBlob);
                }
                if (document.isVersion()) {
                    document = session.getWorkingCopy(document.getRef());
                }
                ToutaticeDocumentHelper.saveDocumentSilently(session, document, true);
            }
        }
    }
}

