/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.core.listener;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.event.Event;
import org.nuxeo.ecm.core.event.EventContext;
import org.nuxeo.ecm.core.event.EventListener;
import org.nuxeo.ecm.core.event.impl.DocumentEventContext;
import org.nuxeo.ecm.platform.picture.api.adapters.PictureResourceAdapter;

public class ToutaticePictureViewListener
implements EventListener {
    public void handleEvent(Event event) throws ClientException {
        if ("updatePictureView".equals(event.getName()) && event.getContext() instanceof DocumentEventContext) {
            EventContext ctx = event.getContext();
            if (!(ctx instanceof DocumentEventContext)) {
                return;
            }
            DocumentEventContext docCtx = (DocumentEventContext)ctx;
            DocumentModel doc = docCtx.getSourceDocument();
            Property fileProp = doc.getProperty("file:content");
            ArrayList pictureTemplates = null;
            PictureResourceAdapter picture = (PictureResourceAdapter)doc.getAdapter(PictureResourceAdapter.class);
            Blob blob = (Blob)fileProp.getValue();
            if (blob == null) {
                return;
            }
            String filename = blob.getFilename();
            String title = doc.getTitle();
            try {
                picture.fillPictureViews(blob, filename, title, pictureTemplates);
            }
            catch (IOException e) {
                throw new ClientException((Throwable)e);
            }
            if (doc.isVersion()) {
                doc.putContextData("allowVersionWrite", (Serializable)Boolean.TRUE);
            }
        }
    }
}

