/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.platform.core.publish;

import fr.toutatice.ecm.platform.core.query.helper.ToutaticeEsQueryHelper;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.platform.publisher.api.PublishedDocument;
import org.nuxeo.ecm.platform.publisher.impl.core.SimpleCorePublishedDocument;

public class PublishedDocumentsFinder {
    private static final Log log = LogFactory.getLog(PublishedDocumentsFinder.class);
    private static final String PUBLISHED_DOCS_QUERY = "select * from Document where ecm:isProxy = 1 and ttc:webid = '%s' and ecm:mixinType <> 'HiddenInNavigation'";
    private static PublishedDocumentsFinder instance;
    private Map<DocumentRef, PublishedDocument> publishedDocumentsIn;

    private PublishedDocumentsFinder() {
    }

    public static synchronized PublishedDocumentsFinder getInstance() {
        if (instance == null) {
            instance = new PublishedDocumentsFinder();
        }
        return instance;
    }

    public Map<DocumentRef, PublishedDocument> find(CoreSession userSession, DocumentModel workingDoc) {
        long b = System.currentTimeMillis();
        String query = String.format(PUBLISHED_DOCS_QUERY, (String)((Object)workingDoc.getPropertyValue("ttc:webid")));
        DocumentModelList proxies = ToutaticeEsQueryHelper.query(userSession, query);
        if (log.isDebugEnabled()) {
            long e = System.currentTimeMillis();
            log.debug((Object)("#find | ES: " + String.valueOf(e - b) + " ms"));
        }
        this.publishedDocumentsIn = new HashMap<DocumentRef, PublishedDocument>(proxies.size());
        for (DocumentModel proxy : proxies) {
            this.publishedDocumentsIn.put(proxy.getParentRef(), (PublishedDocument)new SimpleCorePublishedDocument(proxy));
        }
        return this.publishedDocumentsIn;
    }

    public synchronized Map<DocumentRef, PublishedDocument> getPublishedDocumentsIn() {
        return this.publishedDocumentsIn;
    }

    public synchronized PublishedDocument getPublishedDocumentIn(DocumentRef parentRef) {
        return this.publishedDocumentsIn.get(parentRef);
    }

    public synchronized void refresh() {
        if (this.publishedDocumentsIn != null) {
            this.publishedDocumentsIn.clear();
        }
    }
}

