/*
 * Decompiled with CFR 0.152.
 */
package net.bull.javamelody;

import com.lowagie.text.Chunk;
import com.lowagie.text.Document;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Image;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.bull.javamelody.HtmlThreadInformationsReport;
import net.bull.javamelody.I18N;
import net.bull.javamelody.PdfAbstractTableReport;
import net.bull.javamelody.PdfDocumentFactory;
import net.bull.javamelody.PdfFonts;
import net.bull.javamelody.ThreadInformations;

class PdfThreadInformationsReport
extends PdfAbstractTableReport {
    private final List<ThreadInformations> threadInformationsList;
    private final DecimalFormat integerFormat = I18N.createIntegerFormat();
    private final boolean stackTraceEnabled;
    private final boolean cpuTimeEnabled;
    private final Font cellFont = PdfFonts.TABLE_CELL.getFont();
    private final PdfDocumentFactory pdfDocumentFactory;

    PdfThreadInformationsReport(List<ThreadInformations> threadInformationsList, boolean stackTraceEnabled, PdfDocumentFactory pdfDocumentFactory, Document document) {
        super(document);
        assert (threadInformationsList != null);
        assert (pdfDocumentFactory != null);
        this.threadInformationsList = threadInformationsList;
        this.pdfDocumentFactory = pdfDocumentFactory;
        this.stackTraceEnabled = stackTraceEnabled;
        this.cpuTimeEnabled = !threadInformationsList.isEmpty() && threadInformationsList.get(0).getCpuTimeMillis() != -1L;
    }

    @Override
    void toPdf() throws DocumentException, IOException {
        this.writeHeader();
        for (ThreadInformations threadInformations : this.threadInformationsList) {
            this.nextRow();
            this.writeThreadInformations(threadInformations);
        }
        this.addTableToDocument();
        Paragraph tempsThreads = new Paragraph(PdfThreadInformationsReport.getString("Temps_threads") + '\n', this.cellFont);
        tempsThreads.setAlignment(2);
        this.addToDocument((Element)tempsThreads);
    }

    void writeDeadlocks() throws DocumentException {
        ArrayList<ThreadInformations> deadlockedThreads = new ArrayList<ThreadInformations>();
        for (ThreadInformations thread : this.threadInformationsList) {
            if (!thread.isDeadlocked()) continue;
            deadlockedThreads.add(thread);
        }
        if (!deadlockedThreads.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            sb.append('\n');
            sb.append(PdfThreadInformationsReport.getString("Threads_deadlocks"));
            String separator = " ";
            for (ThreadInformations thread : deadlockedThreads) {
                sb.append(separator);
                sb.append(thread.getName());
                separator = ", ";
            }
            sb.append('\n');
            this.addToDocument((Element)new Phrase(sb.toString(), PdfFonts.SEVERE_CELL.getFont()));
        }
    }

    private void writeHeader() throws DocumentException {
        List<String> headers = this.createHeaders();
        int[] relativeWidths = new int[headers.size()];
        Arrays.fill(relativeWidths, 0, headers.size(), 1);
        relativeWidths[0] = 3;
        relativeWidths[3] = 2;
        if (this.stackTraceEnabled) {
            relativeWidths[4] = 6;
        }
        this.initTable(headers, relativeWidths);
    }

    private List<String> createHeaders() {
        ArrayList<String> headers = new ArrayList<String>();
        headers.add(PdfThreadInformationsReport.getString("Thread"));
        headers.add(PdfThreadInformationsReport.getString("Demon"));
        headers.add(PdfThreadInformationsReport.getString("Priorite"));
        headers.add(PdfThreadInformationsReport.getString("Etat"));
        if (this.stackTraceEnabled) {
            headers.add(PdfThreadInformationsReport.getString("Methode_executee"));
        }
        if (this.cpuTimeEnabled) {
            headers.add(PdfThreadInformationsReport.getString("Temps_cpu"));
            headers.add(PdfThreadInformationsReport.getString("Temps_user"));
        }
        return headers;
    }

    private void writeThreadInformations(ThreadInformations threadInformations) throws DocumentException, IOException {
        PdfPCell defaultCell = this.getDefaultCell();
        defaultCell.setHorizontalAlignment(0);
        this.addCell(threadInformations.getName());
        defaultCell.setHorizontalAlignment(1);
        if (threadInformations.isDaemon()) {
            this.addCell(PdfThreadInformationsReport.getString("oui"));
        } else {
            this.addCell(PdfThreadInformationsReport.getString("non"));
        }
        defaultCell.setHorizontalAlignment(2);
        this.addCell(this.integerFormat.format(threadInformations.getPriority()));
        defaultCell.setHorizontalAlignment(0);
        PdfPCell cell = new PdfPCell();
        Paragraph paragraph = new Paragraph(this.getDefaultCell().getLeading() + this.cellFont.getSize());
        paragraph.add((Object)new Chunk(this.getImage("bullets/" + HtmlThreadInformationsReport.getStateIcon(threadInformations)), 0.0f, -1.0f));
        paragraph.add((Object)new Phrase(String.valueOf((Object)threadInformations.getState()), this.cellFont));
        cell.addElement((Element)paragraph);
        this.addCell(cell);
        if (this.stackTraceEnabled) {
            this.addCell(threadInformations.getExecutedMethod());
        }
        if (this.cpuTimeEnabled) {
            defaultCell.setHorizontalAlignment(2);
            this.addCell(this.integerFormat.format(threadInformations.getCpuTimeMillis()));
            this.addCell(this.integerFormat.format(threadInformations.getUserTimeMillis()));
        }
    }

    private Image getImage(String resourceFileName) throws DocumentException, IOException {
        return this.pdfDocumentFactory.getSmallImage(resourceFileName);
    }
}

