/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.drive.services;

import fr.toutatice.ecm.drive.services.helper.DriveHelper;
import fr.toutatice.ecm.platform.core.services.infos.provider.DocumentInformationsProvider;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.cache.CacheAttributesChecker;
import org.nuxeo.ecm.core.cache.CacheService;
import org.nuxeo.ecm.directory.Session;
import org.nuxeo.ecm.directory.api.DirectoryService;
import org.nuxeo.ecm.tokenauth.service.TokenAuthenticationService;
import org.nuxeo.runtime.api.Framework;

public class DriveEditInfosProvider
implements DocumentInformationsProvider {
    private static final Log log = LogFactory.getLog(DriveEditInfosProvider.class);
    public static final String DRIVE_EDIT_URL = "driveEditURL";
    public static final String DRIVE_ENABLED = "driveEnabled";
    private static TokenAuthenticationService tokenAuthService;
    private static CacheService cs;

    protected static TokenAuthenticationService getTokenAuthService() {
        if (tokenAuthService == null) {
            tokenAuthService = (TokenAuthenticationService)Framework.getService(TokenAuthenticationService.class);
        }
        return tokenAuthService;
    }

    private static CacheService getCacheService() {
        if (cs == null) {
            cs = (CacheService)Framework.getService(CacheService.class);
        }
        return cs;
    }

    public Map<String, Object> fetchInfos(CoreSession coreSession, DocumentModel currentDocument) throws ClientException {
        HashMap<String, Object> infos = new HashMap<String, Object>(1);
        String userName = coreSession.getPrincipal().getName();
        boolean isAvailableDoc = currentDocument != null && !currentDocument.isFolder() && DriveHelper.getFileSystemItem(currentDocument) != null;
        long begin = System.currentTimeMillis();
        DocumentModelList tokensOfUser = DriveEditInfosProvider.getTokenAuthService().getTokenBindings(userName);
        boolean driveEnabled = tokensOfUser != null && tokensOfUser.size() > 0;
        infos.put(DRIVE_ENABLED, driveEnabled);
        if (driveEnabled && isAvailableDoc) {
            boolean driveRunning;
            boolean canWrite = coreSession.hasPermission(currentDocument.getRef(), "Write");
            String[] tokenInfos = this.getTokenInfos(userName);
            boolean bl = driveRunning = tokenInfos != null;
            if (canWrite && driveRunning) {
                infos.put(DRIVE_EDIT_URL, DriveHelper.getDriveEditURL(coreSession, currentDocument));
            }
        }
        if (log.isTraceEnabled()) {
            long time = System.currentTimeMillis() - begin;
            log.trace((Object)(": " + time + " ms"));
        }
        return infos;
    }

    public String[] getTokenInfos(String userName) {
        String[] tokenInfos = null;
        CacheAttributesChecker tokensCache = DriveEditInfosProvider.getCacheService().getCache("ottc-volatile-drive-token-cache");
        String keyCache = "Nx-Drive-T-" + userName;
        try {
            tokenInfos = (String[])tokensCache.get(keyCache);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return tokenInfos;
    }

    private Map<String, Object> getDriveInfos(Map<String, Object> infos, String userName) {
        List<String> tokens = this.getTokensForUser(userName);
        int nbTokens = tokens != null ? tokens.size() : 0;
        infos.put(DRIVE_ENABLED, nbTokens);
        if (nbTokens == 0) {
            log.debug((Object)String.format("No Drive client found for user: '%s'", userName));
        } else if (nbTokens == 1) {
            log.debug((Object)String.format("One Drive client found for user: '%s'", userName));
        } else if (nbTokens > 1) {
            log.debug((Object)String.format("More than one Drive client found for user: '%s'", userName));
        }
        return infos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> getTokensForUser(String userName) {
        LoginContext lc;
        List tokens = null;
        try {
            lc = Framework.login();
        }
        catch (LoginException e) {
            throw new ClientException("Cannot log in as system user", (Throwable)e);
        }
        try (Session session = ((DirectoryService)Framework.getService(DirectoryService.class)).open("authTokens");){
            HashMap<String, String> filters = new HashMap<String, String>(1);
            filters.put("userName", userName);
            tokens = session.getProjection(filters, "token");
        }
        finally {
            try {
                if (lc != null) {
                    lc.logout();
                }
            }
            catch (LoginException e) {
                throw new ClientException("Cannot log out system user", (Throwable)e);
            }
        }
        return tokens;
    }
}

