/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.bytes;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.common.base.Charsets;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamInput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.netty.buffer.ChannelBuffer;
import org.elasticsearch.common.netty.buffer.ChannelBuffers;

public class HashedBytesArray
implements BytesReference {
    private final byte[] bytes;
    private int hash;

    public HashedBytesArray(byte[] bytes) {
        this.bytes = bytes;
    }

    @Override
    public byte get(int index) {
        return this.bytes[index];
    }

    @Override
    public int length() {
        return this.bytes.length;
    }

    @Override
    public BytesReference slice(int from, int length) {
        if (from < 0 || from + length > this.bytes.length) {
            throw new ElasticsearchIllegalArgumentException("can't slice a buffer with length [" + this.bytes.length + "], with slice parameters from [" + from + "], length [" + length + "]");
        }
        return new BytesArray(this.bytes, from, length);
    }

    @Override
    public StreamInput streamInput() {
        return new BytesStreamInput(this.bytes, false);
    }

    @Override
    public void writeTo(OutputStream os) throws IOException {
        os.write(this.bytes);
    }

    @Override
    public void writeTo(GatheringByteChannel channel) throws IOException {
        channel.write(ByteBuffer.wrap(this.bytes));
    }

    @Override
    public byte[] toBytes() {
        return this.bytes;
    }

    @Override
    public BytesArray toBytesArray() {
        return new BytesArray(this.bytes);
    }

    @Override
    public BytesArray copyBytesArray() {
        byte[] copy = new byte[this.bytes.length];
        System.arraycopy(this.bytes, 0, copy, 0, this.bytes.length);
        return new BytesArray(copy);
    }

    @Override
    public ChannelBuffer toChannelBuffer() {
        return ChannelBuffers.wrappedBuffer(this.bytes, 0, this.bytes.length);
    }

    @Override
    public boolean hasArray() {
        return true;
    }

    @Override
    public byte[] array() {
        return this.bytes;
    }

    @Override
    public int arrayOffset() {
        return 0;
    }

    @Override
    public String toUtf8() {
        if (this.bytes.length == 0) {
            return "";
        }
        return new String(this.bytes, Charsets.UTF_8);
    }

    @Override
    public BytesRef toBytesRef() {
        return new BytesRef(this.bytes);
    }

    @Override
    public BytesRef copyBytesRef() {
        byte[] copy = new byte[this.bytes.length];
        System.arraycopy(this.bytes, 0, copy, 0, this.bytes.length);
        return new BytesRef(copy);
    }

    public int hashCode() {
        if (this.hash == 0) {
            this.hash = BytesReference.Helper.bytesHashCode(this);
        }
        return this.hash;
    }

    public boolean equals(Object obj) {
        return BytesReference.Helper.bytesEqual(this, (BytesReference)obj);
    }
}

