/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.io.stream;

import java.io.IOException;
import java.lang.ref.SoftReference;
import org.elasticsearch.common.compress.Compressor;
import org.elasticsearch.common.io.stream.HandlesStreamInput;
import org.elasticsearch.common.io.stream.StreamInput;

public class CachedStreamInput {
    private static final ThreadLocal<SoftReference<Entry>> cache = new ThreadLocal();

    static Entry instance() {
        Entry entry;
        SoftReference<Entry> ref = cache.get();
        Entry entry2 = entry = ref == null ? null : ref.get();
        if (entry == null) {
            HandlesStreamInput handles = new HandlesStreamInput();
            entry = new Entry(handles);
            cache.set(new SoftReference<Entry>(entry));
        }
        return entry;
    }

    public static void clear() {
        cache.remove();
    }

    public static StreamInput compressed(Compressor compressor, StreamInput in) throws IOException {
        return compressor.streamInput(in);
    }

    public static HandlesStreamInput cachedHandles(StreamInput in) {
        HandlesStreamInput handles = CachedStreamInput.instance().handles;
        handles.reset(in);
        return handles;
    }

    public static HandlesStreamInput cachedHandlesCompressed(Compressor compressor, StreamInput in) throws IOException {
        Entry entry = CachedStreamInput.instance();
        entry.handles.reset(compressor.streamInput(in));
        return entry.handles;
    }

    static class Entry {
        final HandlesStreamInput handles;

        Entry(HandlesStreamInput handles) {
            this.handles = handles;
        }
    }
}

