/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.elasticsearch.ElasticsearchIllegalArgumentException;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RestoreSource;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Streamable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentBuilderString;
import org.elasticsearch.index.shard.ShardId;

public class RecoveryState
implements ToXContent,
Streamable {
    private volatile Stage stage = Stage.INIT;
    private Index index = new Index();
    private Translog translog = new Translog();
    private Start start = new Start();
    private Timer timer = new Timer();
    private Type type;
    private ShardId shardId;
    private RestoreSource restoreSource;
    private DiscoveryNode sourceNode;
    private DiscoveryNode targetNode;
    private boolean detailed = false;
    private boolean primary = false;

    public RecoveryState() {
    }

    public RecoveryState(ShardId shardId) {
        this.shardId = shardId;
    }

    public ShardId getShardId() {
        return this.shardId;
    }

    public Stage getStage() {
        return this.stage;
    }

    public RecoveryState setStage(Stage stage) {
        this.stage = stage;
        if (stage == Stage.DONE) {
            this.timer.stopTime(System.currentTimeMillis());
        }
        return this;
    }

    public Index getIndex() {
        return this.index;
    }

    public Start getStart() {
        return this.start;
    }

    public Translog getTranslog() {
        return this.translog;
    }

    public Timer getTimer() {
        return this.timer;
    }

    public Type getType() {
        return this.type;
    }

    public void setType(Type type) {
        this.type = type;
    }

    public void setSourceNode(DiscoveryNode sourceNode) {
        this.sourceNode = sourceNode;
    }

    public DiscoveryNode getSourceNode() {
        return this.sourceNode;
    }

    public void setTargetNode(DiscoveryNode targetNode) {
        this.targetNode = targetNode;
    }

    public DiscoveryNode getTargetNode() {
        return this.targetNode;
    }

    public void setRestoreSource(RestoreSource restoreSource) {
        this.restoreSource = restoreSource;
    }

    public RestoreSource getRestoreSource() {
        return this.restoreSource;
    }

    public void setDetailed(boolean detailed) {
        this.detailed = detailed;
        this.index.detailed(detailed);
    }

    public void setPrimary(boolean primary) {
        this.primary = primary;
    }

    public boolean getPrimary() {
        return this.primary;
    }

    public static RecoveryState readRecoveryState(StreamInput in) throws IOException {
        RecoveryState recoveryState = new RecoveryState();
        recoveryState.readFrom(in);
        return recoveryState;
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        this.timer.startTime(in.readVLong());
        this.timer.stopTime(in.readVLong());
        this.timer.time(in.readVLong());
        this.type = Type.fromId(in.readByte());
        this.stage = Stage.fromId(in.readByte());
        this.shardId = ShardId.readShardId(in);
        this.restoreSource = RestoreSource.readOptionalRestoreSource(in);
        this.targetNode = DiscoveryNode.readNode(in);
        if (in.readBoolean()) {
            this.sourceNode = DiscoveryNode.readNode(in);
        }
        this.index = Index.readIndex(in);
        this.translog = Translog.readTranslog(in);
        this.start = Start.readStart(in);
        this.detailed = in.readBoolean();
        this.primary = in.readBoolean();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeVLong(this.timer.startTime());
        out.writeVLong(this.timer.stopTime());
        out.writeVLong(this.timer.time());
        out.writeByte(this.type.id());
        out.writeByte(this.stage.id());
        this.shardId.writeTo(out);
        out.writeOptionalStreamable(this.restoreSource);
        this.targetNode.writeTo(out);
        out.writeBoolean(this.sourceNode != null);
        if (this.sourceNode != null) {
            this.sourceNode.writeTo(out);
        }
        this.index.writeTo(out);
        this.translog.writeTo(out);
        this.start.writeTo(out);
        out.writeBoolean(this.detailed);
        out.writeBoolean(this.primary);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.field(Fields.ID, this.shardId.id());
        builder.field(Fields.TYPE, this.type.toString());
        builder.field(Fields.STAGE, this.stage.toString());
        builder.field(Fields.PRIMARY, this.primary);
        builder.timeValueField(Fields.START_TIME_IN_MILLIS, Fields.START_TIME, this.timer.startTime);
        builder.timeValueField(Fields.STOP_TIME_IN_MILLIS, Fields.STOP_TIME, this.timer.stopTime);
        builder.timeValueField(Fields.TOTAL_TIME_IN_MILLIS, Fields.TOTAL_TIME, this.timer.time);
        if (this.restoreSource != null) {
            builder.field(Fields.SOURCE);
            this.restoreSource.toXContent(builder, params);
        } else {
            builder.startObject(Fields.SOURCE);
            builder.field(Fields.ID, this.sourceNode.id());
            builder.field(Fields.HOST, this.sourceNode.getHostName());
            builder.field(Fields.TRANSPORT_ADDRESS, this.sourceNode.address().toString());
            builder.field(Fields.IP, this.sourceNode.getHostAddress());
            builder.field(Fields.NAME, this.sourceNode.name());
            builder.endObject();
        }
        builder.startObject(Fields.TARGET);
        builder.field(Fields.ID, this.targetNode.id());
        builder.field(Fields.HOST, this.targetNode.getHostName());
        builder.field(Fields.TRANSPORT_ADDRESS, this.targetNode.address().toString());
        builder.field(Fields.IP, this.targetNode.getHostAddress());
        builder.field(Fields.NAME, this.targetNode.name());
        builder.endObject();
        builder.startObject(Fields.INDEX);
        this.index.detailed(this.detailed);
        this.index.toXContent(builder, params);
        builder.endObject();
        builder.startObject(Fields.TRANSLOG);
        this.translog.toXContent(builder, params);
        builder.endObject();
        builder.startObject(Fields.START);
        this.start.toXContent(builder, params);
        builder.endObject();
        return builder;
    }

    public static class Index
    implements ToXContent,
    Streamable {
        private long startTime = 0L;
        private long time = 0L;
        private List<File> fileDetails = new ArrayList<File>();
        private List<File> reusedFileDetails = new ArrayList<File>();
        private long version = -1L;
        private boolean detailed = false;
        private int totalFileCount = 0;
        private int reusedFileCount = 0;
        private AtomicInteger recoveredFileCount = new AtomicInteger();
        private long totalByteCount = 0L;
        private long reusedByteCount = 0L;
        private AtomicLong recoveredByteCount = new AtomicLong();

        public List<File> fileDetails() {
            return this.fileDetails;
        }

        public List<File> reusedFileDetails() {
            return this.reusedFileDetails;
        }

        public void addFileDetail(String name, long length) {
            this.fileDetails.add(new File(name, length));
        }

        public void addFileDetail(String name, long length, long recovered) {
            File file = new File(name, length);
            file.recovered = recovered;
            this.fileDetails.add(file);
        }

        public void addFileDetails(List<String> names, List<Long> lengths) {
            for (int i = 0; i < names.size(); ++i) {
                this.fileDetails.add(new File(names.get(i), lengths.get(i)));
            }
        }

        public void addReusedFileDetail(String name, long length) {
            this.reusedFileDetails.add(new File(name, length));
        }

        public void addReusedFileDetails(List<String> names, List<Long> lengths) {
            for (int i = 0; i < names.size(); ++i) {
                this.reusedFileDetails.add(new File(names.get(i), lengths.get(i)));
            }
        }

        public File file(String name) {
            for (File file : this.fileDetails) {
                if (!file.name.equals(name)) continue;
                return file;
            }
            for (File file : this.reusedFileDetails) {
                if (!file.name.equals(name)) continue;
                return file;
            }
            return null;
        }

        public long startTime() {
            return this.startTime;
        }

        public void startTime(long startTime) {
            this.startTime = startTime;
        }

        public long time() {
            return this.time;
        }

        public void time(long time) {
            this.time = time;
        }

        public long version() {
            return this.version;
        }

        public void files(int totalFileCount, long totalByteCount, int reusedFileCount, long reusedByteCount) {
            this.totalFileCount = totalFileCount;
            this.totalByteCount = totalByteCount;
            this.reusedFileCount = reusedFileCount;
            this.reusedByteCount = reusedByteCount;
        }

        public int totalFileCount() {
            return this.totalFileCount;
        }

        public void totalFileCount(int totalFileCount) {
            this.totalFileCount = totalFileCount;
        }

        public int recoveredFileCount() {
            return this.recoveredFileCount.get();
        }

        public void recoveredFileCount(int recoveredFileCount) {
            this.recoveredFileCount.set(recoveredFileCount);
        }

        public void addRecoveredFileCount(int updatedCount) {
            this.recoveredFileCount.addAndGet(updatedCount);
        }

        public float percentFilesRecovered(int numberRecovered) {
            if (this.totalFileCount == 0) {
                return 0.0f;
            }
            if (this.totalFileCount - this.reusedFileCount == 0) {
                return 100.0f;
            }
            int d = this.totalFileCount - this.reusedFileCount;
            float result = 100.0f * ((float)numberRecovered / (float)d);
            return result;
        }

        public int numberOfRecoveredFiles() {
            return this.totalFileCount - this.reusedFileCount;
        }

        public long totalByteCount() {
            return this.totalByteCount;
        }

        public void totalByteCount(long totalByteCount) {
            this.totalByteCount = totalByteCount;
        }

        public long recoveredByteCount() {
            return this.recoveredByteCount.longValue();
        }

        public void recoveredByteCount(long recoveredByteCount) {
            this.recoveredByteCount.set(recoveredByteCount);
        }

        public void addRecoveredByteCount(long updatedSize) {
            this.recoveredByteCount.addAndGet(updatedSize);
        }

        public long numberOfRecoveredBytes() {
            return this.recoveredByteCount.get() - this.reusedByteCount;
        }

        public float percentBytesRecovered(long numberRecovered) {
            if (this.totalByteCount == 0L) {
                return 0.0f;
            }
            if (this.totalByteCount - this.reusedByteCount == 0L) {
                return 100.0f;
            }
            long d = this.totalByteCount - this.reusedByteCount;
            float result = 100.0f * ((float)numberRecovered / (float)d);
            return result;
        }

        public int reusedFileCount() {
            return this.reusedFileCount;
        }

        public long reusedByteCount() {
            return this.reusedByteCount;
        }

        public void reusedByteCount(long reusedByteCount) {
            this.reusedByteCount = reusedByteCount;
        }

        public long recoveredTotalSize() {
            return this.totalByteCount - this.reusedByteCount;
        }

        public void updateVersion(long version) {
            this.version = version;
        }

        public void detailed(boolean detailed) {
            this.detailed = detailed;
        }

        public static Index readIndex(StreamInput in) throws IOException {
            Index index = new Index();
            index.readFrom(in);
            return index;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            int i;
            this.startTime = in.readVLong();
            this.time = in.readVLong();
            this.totalFileCount = in.readVInt();
            this.totalByteCount = in.readVLong();
            this.reusedFileCount = in.readVInt();
            this.reusedByteCount = in.readVLong();
            this.recoveredFileCount = new AtomicInteger(in.readVInt());
            this.recoveredByteCount = new AtomicLong(in.readVLong());
            int size = in.readVInt();
            this.fileDetails = new ArrayList<File>(size);
            for (i = 0; i < size; ++i) {
                this.fileDetails.add(File.readFile(in));
            }
            size = in.readVInt();
            this.reusedFileDetails = new ArrayList<File>(size);
            for (i = 0; i < size; ++i) {
                this.reusedFileDetails.add(File.readFile(in));
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.startTime);
            out.writeVLong(this.time);
            out.writeVInt(this.totalFileCount);
            out.writeVLong(this.totalByteCount);
            out.writeVInt(this.reusedFileCount);
            out.writeVLong(this.reusedByteCount);
            out.writeVInt(this.recoveredFileCount.get());
            out.writeVLong(this.recoveredByteCount.get());
            out.writeVInt(this.fileDetails.size());
            for (File file : this.fileDetails) {
                file.writeTo(out);
            }
            out.writeVInt(this.reusedFileDetails.size());
            for (File file : this.reusedFileDetails) {
                file.writeTo(out);
            }
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            int filesRecovered = this.recoveredFileCount.get();
            long bytesRecovered = this.recoveredByteCount.get();
            builder.startObject(Fields.FILES);
            builder.field(Fields.TOTAL, this.totalFileCount);
            builder.field(Fields.REUSED, this.reusedFileCount);
            builder.field(Fields.RECOVERED, filesRecovered);
            builder.field(Fields.PERCENT, String.format(Locale.ROOT, "%1.1f%%", Float.valueOf(this.percentFilesRecovered(filesRecovered))));
            if (this.detailed) {
                builder.startArray(Fields.DETAILS);
                for (File file : this.fileDetails) {
                    file.toXContent(builder, params);
                }
                for (File file : this.reusedFileDetails) {
                    file.toXContent(builder, params);
                }
                builder.endArray();
            }
            builder.endObject();
            builder.startObject(Fields.BYTES);
            builder.field(Fields.TOTAL, this.totalByteCount);
            builder.field(Fields.REUSED, this.reusedByteCount);
            builder.field(Fields.RECOVERED, bytesRecovered);
            builder.field(Fields.PERCENT, String.format(Locale.ROOT, "%1.1f%%", Float.valueOf(this.percentBytesRecovered(bytesRecovered))));
            builder.endObject();
            builder.timeValueField(Fields.TOTAL_TIME_IN_MILLIS, Fields.TOTAL_TIME, this.time);
            return builder;
        }
    }

    public static class File
    implements ToXContent,
    Streamable {
        String name;
        long length;
        long recovered;

        public File() {
        }

        public File(String name, long length) {
            this.name = name;
            this.length = length;
        }

        public void updateRecovered(long length) {
            this.recovered += length;
        }

        public static File readFile(StreamInput in) throws IOException {
            File file = new File();
            file.readFrom(in);
            return file;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.name = in.readString();
            this.length = in.readVLong();
            this.recovered = in.readVLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.name);
            out.writeVLong(this.length);
            out.writeVLong(this.recovered);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Fields.NAME, this.name);
            builder.field(Fields.LENGTH, this.length);
            builder.field(Fields.RECOVERED, this.recovered);
            builder.endObject();
            return builder;
        }
    }

    public static class Translog
    implements ToXContent,
    Streamable {
        private long startTime = 0L;
        private long time;
        private volatile int currentTranslogOperations = 0;

        public long startTime() {
            return this.startTime;
        }

        public void startTime(long startTime) {
            this.startTime = startTime;
        }

        public long time() {
            return this.time;
        }

        public void time(long time) {
            this.time = time;
        }

        public void addTranslogOperations(int count) {
            this.currentTranslogOperations += count;
        }

        public void incrementTranslogOperations() {
            ++this.currentTranslogOperations;
        }

        public int currentTranslogOperations() {
            return this.currentTranslogOperations;
        }

        public static Translog readTranslog(StreamInput in) throws IOException {
            Translog translog = new Translog();
            translog.readFrom(in);
            return translog;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.startTime = in.readVLong();
            this.time = in.readVLong();
            this.currentTranslogOperations = in.readVInt();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.startTime);
            out.writeVLong(this.time);
            out.writeVInt(this.currentTranslogOperations);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.field(Fields.RECOVERED, this.currentTranslogOperations);
            builder.timeValueField(Fields.TOTAL_TIME_IN_MILLIS, Fields.TOTAL_TIME, this.time);
            return builder;
        }
    }

    public static class Start
    implements ToXContent,
    Streamable {
        private long startTime;
        private long time;
        private long checkIndexTime;

        public long startTime() {
            return this.startTime;
        }

        public void startTime(long startTime) {
            this.startTime = startTime;
        }

        public long time() {
            return this.time;
        }

        public void time(long time) {
            this.time = time;
        }

        public long checkIndexTime() {
            return this.checkIndexTime;
        }

        public void checkIndexTime(long checkIndexTime) {
            this.checkIndexTime = checkIndexTime;
        }

        public static Start readStart(StreamInput in) throws IOException {
            Start start = new Start();
            start.readFrom(in);
            return start;
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            this.startTime = in.readVLong();
            this.time = in.readVLong();
            this.checkIndexTime = in.readVLong();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeVLong(this.startTime);
            out.writeVLong(this.time);
            out.writeVLong(this.checkIndexTime);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.timeValueField(Fields.CHECK_INDEX_TIME_IN_MILLIS, Fields.CHECK_INDEX_TIME, this.checkIndexTime);
            builder.timeValueField(Fields.TOTAL_TIME_IN_MILLIS, Fields.TOTAL_TIME, this.time);
            return builder;
        }
    }

    public static class Timer {
        private long startTime = 0L;
        private long time = 0L;
        private long stopTime = 0L;

        public long startTime() {
            return this.startTime;
        }

        public void startTime(long startTime) {
            this.startTime = startTime;
        }

        public long time() {
            return this.time;
        }

        public void time(long time) {
            this.time = time;
        }

        public long stopTime() {
            return this.stopTime;
        }

        public void stopTime(long stopTime) {
            this.stopTime = stopTime;
        }
    }

    static final class Fields {
        static final XContentBuilderString ID = new XContentBuilderString("id");
        static final XContentBuilderString TYPE = new XContentBuilderString("type");
        static final XContentBuilderString STAGE = new XContentBuilderString("stage");
        static final XContentBuilderString PRIMARY = new XContentBuilderString("primary");
        static final XContentBuilderString START_TIME = new XContentBuilderString("start_time");
        static final XContentBuilderString START_TIME_IN_MILLIS = new XContentBuilderString("start_time_in_millis");
        static final XContentBuilderString STOP_TIME = new XContentBuilderString("stop_time");
        static final XContentBuilderString STOP_TIME_IN_MILLIS = new XContentBuilderString("stop_time_in_millis");
        static final XContentBuilderString TOTAL_TIME = new XContentBuilderString("total_time");
        static final XContentBuilderString TOTAL_TIME_IN_MILLIS = new XContentBuilderString("total_time_in_millis");
        static final XContentBuilderString SOURCE = new XContentBuilderString("source");
        static final XContentBuilderString HOST = new XContentBuilderString("host");
        static final XContentBuilderString TRANSPORT_ADDRESS = new XContentBuilderString("transport_address");
        static final XContentBuilderString IP = new XContentBuilderString("ip");
        static final XContentBuilderString NAME = new XContentBuilderString("name");
        static final XContentBuilderString TARGET = new XContentBuilderString("target");
        static final XContentBuilderString INDEX = new XContentBuilderString("index");
        static final XContentBuilderString TRANSLOG = new XContentBuilderString("translog");
        static final XContentBuilderString START = new XContentBuilderString("start");
        static final XContentBuilderString RECOVERED = new XContentBuilderString("recovered");
        static final XContentBuilderString CHECK_INDEX_TIME = new XContentBuilderString("check_index_time");
        static final XContentBuilderString CHECK_INDEX_TIME_IN_MILLIS = new XContentBuilderString("check_index_time_in_millis");
        static final XContentBuilderString LENGTH = new XContentBuilderString("length");
        static final XContentBuilderString FILES = new XContentBuilderString("files");
        static final XContentBuilderString TOTAL = new XContentBuilderString("total");
        static final XContentBuilderString REUSED = new XContentBuilderString("reused");
        static final XContentBuilderString PERCENT = new XContentBuilderString("percent");
        static final XContentBuilderString DETAILS = new XContentBuilderString("details");
        static final XContentBuilderString BYTES = new XContentBuilderString("bytes");

        Fields() {
        }
    }

    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type GATEWAY = new Type(0);
        public static final /* enum */ Type SNAPSHOT = new Type(1);
        public static final /* enum */ Type REPLICA = new Type(2);
        public static final /* enum */ Type RELOCATION = new Type(3);
        private static final Type[] TYPES;
        private final byte id;
        private static final /* synthetic */ Type[] $VALUES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String name) {
            return Enum.valueOf(Type.class, name);
        }

        private Type(byte id) {
            this.id = id;
        }

        public byte id() {
            return this.id;
        }

        public static Type fromId(byte id) throws ElasticsearchIllegalArgumentException {
            if (id < 0 || id >= TYPES.length) {
                throw new ElasticsearchIllegalArgumentException("No mapping for id [" + id + "]");
            }
            return TYPES[id];
        }

        static {
            $VALUES = new Type[]{GATEWAY, SNAPSHOT, REPLICA, RELOCATION};
            TYPES = new Type[Type.values().length];
            for (Type type : Type.values()) {
                assert (type.id() < TYPES.length && type.id() >= 0);
                Type.TYPES[type.id] = type;
            }
        }
    }

    public static final class Stage
    extends Enum<Stage> {
        public static final /* enum */ Stage INIT = new Stage(0);
        public static final /* enum */ Stage INDEX = new Stage(1);
        public static final /* enum */ Stage START = new Stage(2);
        public static final /* enum */ Stage TRANSLOG = new Stage(3);
        public static final /* enum */ Stage FINALIZE = new Stage(4);
        public static final /* enum */ Stage DONE = new Stage(5);
        private static final Stage[] STAGES;
        private final byte id;
        private static final /* synthetic */ Stage[] $VALUES;

        public static Stage[] values() {
            return (Stage[])$VALUES.clone();
        }

        public static Stage valueOf(String name) {
            return Enum.valueOf(Stage.class, name);
        }

        private Stage(byte id) {
            this.id = id;
        }

        public byte id() {
            return this.id;
        }

        public static Stage fromId(byte id) throws ElasticsearchIllegalArgumentException {
            if (id < 0 || id >= STAGES.length) {
                throw new ElasticsearchIllegalArgumentException("No mapping for id [" + id + "]");
            }
            return STAGES[id];
        }

        static {
            $VALUES = new Stage[]{INIT, INDEX, START, TRANSLOG, FINALIZE, DONE};
            STAGES = new Stage[Stage.values().length];
            for (Stage stage : Stage.values()) {
                assert (stage.id() < STAGES.length && stage.id() >= 0);
                Stage.STAGES[stage.id] = stage;
            }
        }
    }
}

