/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.dfs;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.AtomicReaderContext;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.StoredFieldVisitor;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.similarities.Similarity;
import org.elasticsearch.search.dfs.AggregatedDfs;

public class CachedDfSource
extends IndexSearcher {
    private final AggregatedDfs aggregatedDfs;
    private final int maxDoc;

    public CachedDfSource(IndexReader reader, AggregatedDfs aggregatedDfs, Similarity similarity) throws IOException {
        super(reader);
        this.aggregatedDfs = aggregatedDfs;
        this.setSimilarity(similarity);
        this.maxDoc = aggregatedDfs.maxDoc() > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)aggregatedDfs.maxDoc();
    }

    public TermStatistics termStatistics(Term term, TermContext context) throws IOException {
        TermStatistics termStatistics = this.aggregatedDfs.termStatistics().get(term);
        if (termStatistics == null) {
            return super.termStatistics(term, context);
        }
        return termStatistics;
    }

    public CollectionStatistics collectionStatistics(String field) throws IOException {
        CollectionStatistics collectionStatistics = this.aggregatedDfs.fieldStatistics().get(field);
        if (collectionStatistics == null) {
            return super.collectionStatistics(field);
        }
        return collectionStatistics;
    }

    public int maxDoc() {
        return this.maxDoc;
    }

    public Query rewrite(Query query) {
        return query;
    }

    public Document doc(int i) {
        throw new UnsupportedOperationException();
    }

    public void doc(int docID, StoredFieldVisitor fieldVisitor) throws IOException {
        throw new UnsupportedOperationException();
    }

    public Explanation explain(Weight weight, int doc) {
        throw new UnsupportedOperationException();
    }

    protected void search(List<AtomicReaderContext> leaves, Weight weight, Collector collector) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected TopDocs search(Weight weight, ScoreDoc after, int nDocs) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected TopDocs search(List<AtomicReaderContext> leaves, Weight weight, ScoreDoc after, int nDocs) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected TopFieldDocs search(Weight weight, int nDocs, Sort sort, boolean doDocScores, boolean doMaxScore) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected TopFieldDocs search(Weight weight, FieldDoc after, int nDocs, Sort sort, boolean fillFields, boolean doDocScores, boolean doMaxScore) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected TopFieldDocs search(List<AtomicReaderContext> leaves, Weight weight, FieldDoc after, int nDocs, Sort sort, boolean fillFields, boolean doDocScores, boolean doMaxScore) throws IOException {
        throw new UnsupportedOperationException();
    }
}

