/*
 * Decompiled with CFR 0.152.
 */
package org.apache.directory.server.core.collective;

import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import org.apache.directory.server.core.interceptor.context.LookupOperationContext;
import org.apache.directory.server.core.partition.PartitionNexus;
import org.apache.directory.server.schema.registries.AttributeTypeRegistry;
import org.apache.directory.shared.ldap.exception.LdapSchemaViolationException;
import org.apache.directory.shared.ldap.message.ModificationItemImpl;
import org.apache.directory.shared.ldap.message.ResultCodeEnum;
import org.apache.directory.shared.ldap.name.LdapDN;
import org.apache.directory.shared.ldap.schema.AttributeType;
import org.apache.directory.shared.ldap.schema.SchemaUtils;
import org.apache.directory.shared.ldap.util.AttributeUtils;

public class CollectiveAttributesSchemaChecker {
    private PartitionNexus nexus = null;
    private AttributeTypeRegistry attrTypeRegistry = null;

    public CollectiveAttributesSchemaChecker(PartitionNexus nexus, AttributeTypeRegistry attrTypeRegistry) {
        this.nexus = nexus;
        this.attrTypeRegistry = attrTypeRegistry;
    }

    public void checkAdd(LdapDN normName, Attributes entry) throws LdapSchemaViolationException, NamingException {
        Attribute objectClass = entry.get("objectClass");
        if (AttributeUtils.containsValueCaseIgnore((Attribute)objectClass, (Object)"collectiveAttributeSubentry")) {
            return;
        }
        if (this.containsAnyCollectiveAttributes(entry)) {
            throw new LdapSchemaViolationException("Collective attributes cannot be stored in non-collectiveAttributeSubentries", ResultCodeEnum.OTHER);
        }
    }

    public void checkModify(LdapDN normName, int modOp, Attributes mods) throws NamingException {
        ModificationItemImpl[] modsAsArray = new ModificationItemImpl[mods.size()];
        NamingEnumeration<? extends Attribute> allAttrs = mods.getAll();
        int i = 0;
        while (allAttrs.hasMoreElements()) {
            Attribute attr = (Attribute)allAttrs.nextElement();
            modsAsArray[i] = new ModificationItemImpl(modOp, attr);
            ++i;
        }
        this.checkModify(normName, modsAsArray);
    }

    public void checkModify(LdapDN normName, ModificationItemImpl[] mods) throws NamingException {
        Attributes originalEntry = this.nexus.lookup(new LookupOperationContext(normName));
        Attributes targetEntry = SchemaUtils.getTargetEntry((ModificationItemImpl[])mods, (Attributes)originalEntry);
        Attribute targetObjectClasses = targetEntry.get("objectClass");
        if (AttributeUtils.containsValueCaseIgnore((Attribute)targetObjectClasses, (Object)"collectiveAttributeSubentry")) {
            return;
        }
        if (this.addsAnyCollectiveAttributes(mods)) {
            throw new LdapSchemaViolationException("Cannot operate on collective attributes in non-collectiveAttributeSubentries", ResultCodeEnum.OTHER);
        }
    }

    private boolean addsAnyCollectiveAttributes(ModificationItemImpl[] mods) throws NamingException {
        for (ModificationItemImpl mod : mods) {
            Attribute attr = mod.getAttribute();
            String attrID = attr.getID();
            AttributeType attrType = this.attrTypeRegistry.lookup(attrID);
            int modOp = mod.getModificationOp();
            if (modOp != 1 && modOp != 2 || !attrType.isCollective()) continue;
            return true;
        }
        return false;
    }

    private boolean containsAnyCollectiveAttributes(Attributes entry) throws NamingException {
        NamingEnumeration<String> allIDs = entry.getIDs();
        while (allIDs.hasMoreElements()) {
            String attrTypeStr = (String)allIDs.nextElement();
            AttributeType attrType = this.attrTypeRegistry.lookup(attrTypeStr);
            if (!attrType.isCollective()) continue;
            return true;
        }
        return false;
    }
}

