/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.elasticsearch.codec;

import fr.toutatice.ecm.elasticsearch.search.TTCSearchResponse;
import java.io.IOException;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.JsonProcessingException;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.aggregations.bucket.terms.StringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.Terms;
import org.nuxeo.ecm.automation.io.services.codec.ObjectCodec;
import org.opentoutatice.elasticsearch.core.reindexing.docs.manager.IndexNAliasManager;
import org.opentoutatice.elasticsearch.core.reindexing.docs.transitory.TransitoryIndexUse;
import org.opentoutatice.elasticsearch.utils.MessageUtils;

public class TTCEsCodec
extends ObjectCodec<TTCSearchResponse> {
    private static final Log log = LogFactory.getLog(TTCEsCodec.class);

    public TTCEsCodec() {
        super(TTCSearchResponse.class);
    }

    public String getType() {
        return "esresponse";
    }

    public void write(JsonGenerator jg, TTCSearchResponse value) throws IOException {
        SearchHits upperhits = value.getSearchResponse().getHits();
        String schemasRegex = value.getSchemasRegex();
        SearchHit[] searchhits = upperhits.getHits();
        jg.writeStartObject();
        jg.writeStringField("entity-type", "documents");
        if (value.isPaginable()) {
            jg.writeBooleanField("isPaginable", value.isPaginable());
            jg.writeNumberField("resultsCount", searchhits.length);
            jg.writeNumberField("totalSize", upperhits.getTotalHits());
            jg.writeNumberField("pageSize", value.getPageSize());
            long pageCount = 0L;
            if (value.getPageSize() > 0) {
                pageCount = upperhits.getTotalHits() / (long)value.getPageSize() + (long)(0L < upperhits.getTotalHits() % (long)value.getPageSize() ? 1 : 0);
            }
            jg.writeNumberField("pageCount", pageCount);
            jg.writeNumberField("currentPageIndex", value.getCurrentPageIndex());
        }
        jg.writeArrayFieldStart("entries");
        if (this.hasToFilterDuplicate(value.getSearchResponse())) {
            this.writeDuplicateFilteredEntries(jg, schemasRegex, value.getSearchResponse());
        } else {
            this.writeEntries(jg, schemasRegex, searchhits);
        }
        jg.writeEndArray();
        jg.writeEndObject();
        jg.flush();
    }

    protected boolean hasToFilterDuplicate(SearchResponse searchResponse) {
        return searchResponse.getAggregations() != null ? searchResponse.getAggregations().get("duplicate_aggregate") != null : false;
    }

    protected void writeEntries(JsonGenerator jg, String schemasRegex, SearchHit[] searchhits) throws IOException, JsonGenerationException, JsonProcessingException {
        for (SearchHit hit : searchhits) {
            this.writeEntry(jg, schemasRegex, hit.getSource());
        }
    }

    protected void writeDuplicateFilteredEntries(JsonGenerator jg, String schemasRegex, SearchResponse searchResponse) throws JsonGenerationException, JsonProcessingException, IOException {
        long startTime = System.currentTimeMillis();
        SearchHit[] searchHits = searchResponse.getHits().getHits();
        StringTerms duplicateAggs = (StringTerms)searchResponse.getAggregations().get("duplicate_aggregate");
        LinkedList<String> duplicateIds = new LinkedList<String>();
        for (Terms.Bucket bucket : duplicateAggs.getBuckets()) {
            if (bucket.getDocCount() <= 1L) continue;
            duplicateIds.add(bucket.getKey());
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("List of duplicates: [%s]", MessageUtils.listToString(duplicateIds)));
        }
        if (duplicateIds.size() == 0) {
            this.writeEntries(jg, schemasRegex, searchHits);
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("[%s] duplicates ids found: filtering...", duplicateIds.size()));
            }
            String newIdx = IndexNAliasManager.get().getIndexOfAlias(TransitoryIndexUse.Write.getAlias());
            for (SearchHit hit : searchHits) {
                Map source = hit.getSource();
                String uuid = (String)source.get("ecm:uuid");
                if (duplicateIds.contains(uuid)) {
                    if (!StringUtils.equals((String)newIdx, (String)hit.getIndex())) continue;
                    if (log.isTraceEnabled()) {
                        log.trace((Object)String.format("Keeping duplicate [%s] from index [%s]", uuid, hit.getIndex()));
                    }
                    this.writeEntry(jg, schemasRegex, source);
                    continue;
                }
                this.writeEntry(jg, schemasRegex, source);
            }
        }
        if (log.isDebugEnabled()) {
            long duration = System.currentTimeMillis() - startTime;
            log.debug((Object)String.format("#writeDuplicateFilteredEntries done: [%s] ms", String.valueOf(duration)));
        }
    }

    private void writeEntry(JsonGenerator jg, String schemasRegex, Map<String, Object> source) throws IOException, JsonGenerationException, JsonProcessingException {
        jg.writeStartObject();
        jg.writeStringField("entity-type", "document");
        jg.writeStringField("repository", (String)source.get("ecm:repository"));
        jg.writeStringField("uid", (String)source.get("ecm:uuid"));
        jg.writeStringField("path", (String)source.get("ecm:path"));
        jg.writeStringField("type", (String)source.get("ecm:primaryType"));
        jg.writeStringField("state", (String)source.get("ecm:currentLifeCycleState"));
        jg.writeStringField("parentRef", (String)source.get("ecm:parentId"));
        jg.writeStringField("versionLabel", (String)source.get("ecm:versionLabel"));
        jg.writeStringField("isCheckedOut", "");
        jg.writeStringField("title", (String)source.get("dc:title"));
        jg.writeStringField("lastModified", (String)source.get("dc:modified"));
        jg.writeObjectField("facets", source.get("ecm:mixinType"));
        jg.writeStringField("changeToken", (String)source.get("ecm:changeToken"));
        jg.writeObjectFieldStart("properties");
        for (String key : source.keySet()) {
            if (key.matches("ecm:.+") || !key.matches(schemasRegex)) continue;
            jg.writeObjectField(key, source.get(key));
        }
        jg.writeEndObject();
        jg.writeEndObject();
        jg.flush();
    }
}

