/*
 * Decompiled with CFR 0.152.
 */
package fr.toutatice.ecm.elasticsearch.servlet;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.runtime.api.Framework;

public class VcsToEsQueryFilter
implements Filter {
    private static final String APP_HEADER = "X-Application-Name";
    private static final String APP_HEADER_VALUE = "OSIVIA Portal";
    public static final String QUERYING_ES_FORCE = "ottc.querying.es.force";
    public static final String QUERYING_VCS_FORCE_FLAG = "nx_querying_vcs_force";
    private static final String QUERY_ES_OP_RESOURCE = "/site/automation/Document.QueryES";
    public static final String QUERY_ES_COMPAT_MODE = "qEsCompat";

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!(request instanceof HttpServletRequest)) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpReq = (HttpServletRequest)request;
        boolean queryingEsFromConfig = Boolean.valueOf(Framework.getProperty((String)QUERYING_ES_FORCE, (String)"true"));
        boolean queryingVcs = Boolean.valueOf(httpReq.getHeader(QUERYING_VCS_FORCE_FLAG));
        boolean authorizedApp = false;
        String applicationName = httpReq.getHeader(APP_HEADER);
        if (StringUtils.isNotBlank((String)applicationName) && APP_HEADER_VALUE.equals(applicationName)) {
            authorizedApp = true;
        }
        if (authorizedApp && queryingEsFromConfig && !queryingVcs) {
            String opId = StringUtils.substringAfterLast((String)httpReq.getPathInfo(), (String)"/");
            if ("Document.Query".equals(opId) || "Document.PageProvider".equals(opId)) {
                httpReq.getRequestDispatcher(QUERY_ES_OP_RESOURCE).forward(request, response);
            } else {
                chain.doFilter(request, response);
            }
        } else {
            chain.doFilter(request, response);
        }
    }

    public void destroy() {
    }
}

