/*
 * Decompiled with CFR 0.152.
 */
package org.opentoutatice.elasticsearch.core.reindexing.docs.es.state;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.action.admin.cluster.state.ClusterStateResponse;
import org.elasticsearch.client.AdminClient;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.collect.UnmodifiableIterator;
import org.elasticsearch.common.hppc.cursors.ObjectObjectCursor;
import org.opentoutatice.elasticsearch.core.reindexing.docs.es.state.EsState;
import org.opentoutatice.elasticsearch.core.reindexing.docs.es.state.exception.ReIndexingStateException;
import org.opentoutatice.elasticsearch.core.reindexing.docs.manager.IndexNAliasManager;
import org.opentoutatice.elasticsearch.core.reindexing.docs.transitory.TransitoryIndexUse;

public class EsStateChecker {
    private static EsStateChecker instance;

    private EsStateChecker() {
    }

    public static synchronized EsStateChecker get() {
        if (instance == null) {
            instance = new EsStateChecker();
        }
        return instance;
    }

    public EsState getEsState() throws InterruptedException, ExecutionException {
        ImmutableOpenMap aliases;
        EsState esState = new EsState();
        AdminClient adminClient = IndexNAliasManager.get().getAdminClient();
        ImmutableOpenMap indices = ((ClusterStateResponse)adminClient.cluster().prepareState().get()).getState().getMetaData().getIndices();
        if (indices != null) {
            UnmodifiableIterator indicesIt = indices.keysIt();
            while (indicesIt.hasNext()) {
                String index = (String)indicesIt.next();
                esState.addIndex(index);
            }
        }
        if ((aliases = ((ClusterStateResponse)adminClient.cluster().prepareState().get()).getState().getMetaData().getAliases()) != null) {
            for (ObjectObjectCursor alias : aliases) {
                String aliasName = (String)alias.key;
                ImmutableOpenMap indicesOfMap = (ImmutableOpenMap)alias.value;
                ArrayList<String> indicesOf = new ArrayList<String>();
                if (indicesOfMap != null) {
                    UnmodifiableIterator idxIt = indicesOfMap.keysIt();
                    while (idxIt.hasNext()) {
                        String idx = (String)idxIt.next();
                        indicesOf.add(idx);
                    }
                }
                esState.addAlias(aliasName, indicesOf);
            }
        }
        return esState;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean aliasExistsWithOnlyOneIndex(String aliasName) throws ReIndexingStateException {
        boolean verified = false;
        if (!IndexNAliasManager.get().aliasExists(aliasName).booleanValue()) throw new ReIndexingStateException(String.format("Alias [%s] does not exist. You must create it.", aliasName));
        List<String> indicesOfAlias = IndexNAliasManager.get().getIndicesOfAlias(aliasName);
        if (indicesOfAlias == null) throw new ReIndexingStateException(String.format("No index defined for alias [%s]. Fix Elastiseach state.", aliasName));
        int nbIndices = indicesOfAlias.size();
        if (nbIndices == 1) {
            return true;
        }
        if (nbIndices == 0) {
            throw new ReIndexingStateException(String.format("No index defined for alias [%s]. Fix Elastisearch state.", aliasName));
        }
        if (indicesOfAlias.size() <= 1) return verified;
        throw new ReIndexingStateException(String.format("[%s] indices defined for alias [%s]. Fix Elastisearch state.", String.valueOf(nbIndices), aliasName));
    }

    public boolean transientAliasesNotExist() throws ReIndexingStateException {
        boolean verified = false;
        if (IndexNAliasManager.get().mayTransientAliasesExist().booleanValue()) {
            throw new ReIndexingStateException(String.format("One or both of transient aliases [%s, %s] still exist. Fix Elastisearch state", TransitoryIndexUse.Read.getAlias(), TransitoryIndexUse.Write.getAlias()));
        }
        verified = true;
        return verified;
    }

    public boolean mayFormerAliasExists(String aliasName) throws ReIndexingStateException {
        boolean verified = false;
        String formerAliasName = IndexNAliasManager.get().getFormerAliasName(aliasName);
        if (IndexNAliasManager.get().aliasExists(formerAliasName).booleanValue()) {
            boolean bl = verified = !StringUtils.equals((String)IndexNAliasManager.get().getIndexOfAlias(aliasName), (String)IndexNAliasManager.get().getIndexOfAlias(formerAliasName));
            if (!verified) {
                throw new ReIndexingStateException(String.format("Bad existing former alias [%s]: points on current index [%s]", formerAliasName, IndexNAliasManager.get().getIndexOfAlias(formerAliasName)));
            }
        } else {
            verified = true;
        }
        return verified;
    }
}

