/*
 * Decompiled with CFR 0.152.
 */
package org.opentoutatice.elasticsearch.core.service;

import com.google.common.util.concurrent.ListenableFuture;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthResponse;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthStatus;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.NoNodeAvailableException;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.node.Node;
import org.elasticsearch.node.NodeBuilder;
import org.nuxeo.elasticsearch.config.ElasticSearchIndexConfig;
import org.nuxeo.elasticsearch.config.ElasticSearchLocalConfig;
import org.nuxeo.elasticsearch.config.ElasticSearchRemoteConfig;
import org.nuxeo.runtime.api.Framework;
import org.opentoutatice.elasticsearch.api.OttcElasticSearchAdmin;
import org.opentoutatice.elasticsearch.config.OttcElasticSearchIndexOrAliasConfig;
import org.opentoutatice.elasticsearch.config.exception.AliasConfigurationException;
import org.opentoutatice.elasticsearch.core.reindexing.docs.manager.IndexNAliasManager;
import org.opentoutatice.elasticsearch.core.reindexing.docs.manager.ReIndexingRunnerManager;
import org.opentoutatice.elasticsearch.core.reindexing.docs.test.EsNodeTestInitializer;
import org.opentoutatice.elasticsearch.core.reindexing.docs.transitory.TransitoryIndexUse;

public class OttcElasticSearchAdminImpl
implements OttcElasticSearchAdmin {
    private static final Log log = LogFactory.getLog(OttcElasticSearchAdminImpl.class);
    private static final String TIMEOUT_WAIT_FOR_CLUSTER = "30s";
    final AtomicInteger totalCommandProcessed = new AtomicInteger(0);
    private final Map<String, String> indexNames = new HashMap<String, String>();
    private final Map<String, String> repoNames = new HashMap<String, String>();
    private final Map<String, ElasticSearchIndexConfig> indexConfig;
    private Node localNode;
    private Client client;
    private boolean indexInitDone = false;
    private final ElasticSearchLocalConfig localConfig;
    private final ElasticSearchRemoteConfig remoteConfig;
    private String[] includeSourceFields;
    private String[] excludeSourceFields;
    private boolean embedded = true;
    private List<String> repositoryInitialized = new ArrayList<String>();

    public OttcElasticSearchAdminImpl(ElasticSearchLocalConfig localConfig, ElasticSearchRemoteConfig remoteConfig, Map<String, ElasticSearchIndexConfig> indexConfig) throws InterruptedException, ExecutionException {
        this.remoteConfig = remoteConfig;
        this.localConfig = localConfig;
        this.indexConfig = indexConfig;
        this.connect();
        IndexNAliasManager.init(this.client.admin());
        this.initializeIndexes();
    }

    private void connect() {
        if (this.client != null) {
            return;
        }
        if (this.remoteConfig != null) {
            this.client = this.connectToRemote(this.remoteConfig);
            this.embedded = false;
        } else {
            this.localNode = this.createEmbeddedNode(this.localConfig);
            this.client = this.connectToEmbedded();
            this.embedded = true;
            if (Framework.isTestModeSet()) {
                EsNodeTestInitializer.initializeEsNodeInTestMode(this.client, log);
            }
        }
        this.checkClusterHealth(new String[0]);
        log.info((Object)"ES Connected");
    }

    public void disconnect() {
        if (this.client != null) {
            this.client.close();
            this.client = null;
            this.indexInitDone = false;
            log.info((Object)"ES Disconnected");
        }
        if (this.localNode != null) {
            this.localNode.close();
            this.localNode = null;
            log.info((Object)"ES embedded Node Stopped");
        }
    }

    private Node createEmbeddedNode(ElasticSearchLocalConfig conf) {
        log.info((Object)"ES embedded Node Initializing (local in JVM)");
        if (conf == null) {
            throw new IllegalStateException("No embedded configuration defined");
        }
        if (!Framework.isTestModeSet()) {
            log.warn((Object)"Elasticsearch embedded configuration is ONLY for testing purpose. You need to create a dedicated Elasticsearch cluster for production.");
        }
        ImmutableSettings.Builder sBuilder = ImmutableSettings.settingsBuilder();
        sBuilder.put("http.enabled", conf.httpEnabled()).put("path.data", conf.getDataPath()).put("index.number_of_shards", 1).put("index.number_of_replicas", 0).put("cluster.name", conf.getClusterName()).put("node.name", conf.getNodeName()).put("http.netty.worker_count", 4).put("cluster.routing.allocation.disk.threshold_enabled", false);
        if (conf.getIndexStorageType() != null) {
            sBuilder.put("index.store.type", conf.getIndexStorageType());
            if (conf.getIndexStorageType().equals("memory")) {
                sBuilder.put("gateway.type", "none");
            }
        }
        Settings settings = sBuilder.build();
        log.debug((Object)("Using settings: " + settings.toDelimitedString(',')));
        Node ret = NodeBuilder.nodeBuilder().local(true).settings(settings).node();
        assert (ret != null) : "Can not create an embedded ES Node";
        return ret;
    }

    private Client connectToEmbedded() {
        log.info((Object)"Connecting to embedded ES");
        Client ret = this.localNode.start().client();
        assert (ret != null) : "Can not connect to embedded ES Node";
        return ret;
    }

    private Client connectToRemote(ElasticSearchRemoteConfig config) {
        log.info((Object)("Connecting to remote ES cluster: " + config));
        ImmutableSettings.Builder builder = ImmutableSettings.settingsBuilder().put("cluster.name", config.getClusterName()).put("client.transport.nodes_sampler_interval", config.getSamplerInterval()).put("client.transport.ping_timeout", config.getPingTimeout()).put("client.transport.ignore_cluster_name", config.isIgnoreClusterName()).put("client.transport.sniff", config.isClusterSniff());
        Settings settings = builder.build();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Using settings: " + settings.toDelimitedString(',')));
        }
        TransportClient ret = new TransportClient(settings);
        String[] addresses = config.getAddresses();
        if (addresses == null) {
            log.error((Object)"You need to provide an addressList to join a cluster");
        } else {
            for (String item : config.getAddresses()) {
                String[] address = item.split(":");
                log.debug((Object)("Add transport address: " + item));
                try {
                    InetAddress inet = InetAddress.getByName(address[0]);
                    ret.addTransportAddress((TransportAddress)new InetSocketTransportAddress(inet, Integer.parseInt(address[1])));
                }
                catch (UnknownHostException e) {
                    log.error((Object)("Unable to resolve host " + address[0]), (Throwable)e);
                }
            }
        }
        assert (ret != null) : "Unable to create a remote client";
        return ret;
    }

    public void checkClusterHealth(String ... indexNames) {
        if (this.client == null) {
            throw new IllegalStateException("No es client available");
        }
        String errorMessage = null;
        try {
            log.debug((Object)("Waiting for cluster yellow health status, indexes: " + Arrays.toString(indexNames)));
            ClusterHealthResponse ret = (ClusterHealthResponse)this.client.admin().cluster().prepareHealth(indexNames).setTimeout(TIMEOUT_WAIT_FOR_CLUSTER).setWaitForYellowStatus().get();
            if (ret.isTimedOut()) {
                errorMessage = "ES Cluster health status not Yellow after 30s give up: " + ret;
            } else if (indexNames.length > 0 && ret.getStatus() != ClusterHealthStatus.GREEN) {
                log.warn((Object)("Es Cluster ready but not GREEN: " + ret));
            } else {
                log.info((Object)("ES Cluster ready: " + ret));
            }
        }
        catch (NoNodeAvailableException e) {
            errorMessage = "Failed to connect to elasticsearch, check addressList and clusterName: " + e.getMessage();
        }
        if (errorMessage != null) {
            log.error((Object)errorMessage);
            throw new RuntimeException(errorMessage);
        }
    }

    private void initializeIndexes() {
        for (ElasticSearchIndexConfig conf : this.indexConfig.values()) {
            if (!"doc".equals(conf.getType())) continue;
            log.info((Object)("Associate index " + conf.getName() + " with repository: " + conf.getRepositoryName()));
            this.indexNames.put(conf.getRepositoryName(), conf.getName());
            this.repoNames.put(conf.getName(), conf.getRepositoryName());
            LinkedHashSet<String> set = new LinkedHashSet<String>();
            if (this.includeSourceFields != null) {
                set.addAll(Arrays.asList(this.includeSourceFields));
            }
            set.addAll(Arrays.asList(conf.getIncludes()));
            if (set.contains("*")) {
                set.clear();
                set.add("*");
            }
            this.includeSourceFields = set.toArray(new String[set.size()]);
            set.clear();
            if (this.excludeSourceFields != null) {
                set.addAll(Arrays.asList(this.excludeSourceFields));
            }
            set.addAll(Arrays.asList(conf.getExcludes()));
            this.excludeSourceFields = set.toArray(new String[set.size()]);
        }
        this.initIndexes(false);
    }

    public void refreshRepositoryIndex(String repositoryName) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Refreshing index associated with repo: " + repositoryName));
        }
        this.getClient().admin().indices().prepareRefresh(new String[]{this.getIndexNameForRepository(repositoryName)}).execute().actionGet();
        if (log.isDebugEnabled()) {
            log.debug((Object)"Refreshing index done");
        }
    }

    public void flushRepositoryIndex(String repositoryName) {
        log.warn((Object)("Flushing index associated with repo: " + repositoryName));
        this.getClient().admin().indices().prepareFlush(new String[]{this.getIndexNameForRepository(repositoryName)}).execute().actionGet();
        log.info((Object)"Flushing index done");
    }

    public void refresh() {
        for (String repositoryName : this.indexNames.keySet()) {
            this.refreshRepositoryIndex(repositoryName);
        }
    }

    public void flush() {
        for (String repositoryName : this.indexNames.keySet()) {
            this.flushRepositoryIndex(repositoryName);
        }
    }

    public void optimizeIndex(String indexName) {
        log.warn((Object)("Optimizing index: " + indexName));
        for (ElasticSearchIndexConfig conf : this.indexConfig.values()) {
            if (!conf.getName().equals(indexName)) continue;
            this.getClient().admin().indices().prepareOptimize(new String[]{indexName}).get();
        }
        log.info((Object)"Optimize done");
    }

    public void optimizeRepositoryIndex(String repositoryName) {
        this.optimizeIndex(this.getIndexNameForRepository(repositoryName));
    }

    public void optimize() {
        for (ElasticSearchIndexConfig conf : this.indexConfig.values()) {
            this.optimizeIndex(conf.getName());
        }
    }

    public Client getClient() {
        return this.client;
    }

    public void initIndexes(boolean dropIfExists) {
        this.indexInitDone = false;
        for (ElasticSearchIndexConfig conf : this.indexConfig.values()) {
            this.initIndex(conf, dropIfExists);
        }
        log.info((Object)"ES Service ready");
        this.indexInitDone = true;
    }

    public void dropAndInitIndex(String indexName) {
        log.info((Object)("Drop and init index: " + indexName));
        this.indexInitDone = false;
        for (ElasticSearchIndexConfig conf : this.indexConfig.values()) {
            if (!conf.getName().equals(indexName)) continue;
            this.initIndex(conf, true);
        }
        this.indexInitDone = true;
    }

    public void dropAndInitRepositoryIndex(String repositoryName) {
        log.info((Object)("Drop and init index of repository: " + repositoryName));
        this.indexInitDone = false;
        for (ElasticSearchIndexConfig conf : this.indexConfig.values()) {
            if (!"doc".equals(conf.getType()) || !repositoryName.equals(conf.getRepositoryName())) continue;
            this.initIndex(conf, true);
        }
        this.indexInitDone = true;
    }

    public List<String> getRepositoryNames() {
        return Collections.unmodifiableList(new ArrayList<String>(this.indexNames.keySet()));
    }

    public void initIndex(ElasticSearchIndexConfig conf, boolean dropIfExists) {
        if (!conf.mustCreate()) {
            if (this.aliasConfigured(conf.getRepositoryName()) && !IndexNAliasManager.get().aliasExists(conf.getName()).booleanValue()) {
                this.getIndexNames().put(conf.getRepositoryName(), null);
                this.getRepoNames().remove(conf.getName());
                log.fatal((Object)new AliasConfigurationException(String.format("Alias [%s] does not exist: you must create it before use alias mode.", conf.getName())));
            }
            return;
        }
        log.info((Object)String.format("Initialize index: %s, type: %s", conf.getName(), conf.getType()));
        boolean mappingExists = false;
        boolean indexExists = ((IndicesExistsResponse)this.getClient().admin().indices().prepareExists(new String[]{conf.getName()}).execute().actionGet()).isExists();
        if (indexExists) {
            if (!dropIfExists) {
                log.debug((Object)("Index " + conf.getName() + " already exists"));
                mappingExists = ((ImmutableOpenMap)((GetMappingsResponse)this.getClient().admin().indices().prepareGetMappings(new String[]{conf.getName()}).execute().actionGet()).getMappings().get((Object)conf.getName())).containsKey((Object)"doc");
            } else {
                if (!Framework.isTestModeSet()) {
                    log.warn((Object)String.format("Initializing index: %s, type: %s with dropIfExists flag, deleting an existing index", conf.getName(), conf.getType()));
                }
                this.getClient().admin().indices().delete(new DeleteIndexRequest(conf.getName())).actionGet();
                indexExists = false;
            }
        }
        if (!indexExists) {
            log.info((Object)String.format("Creating index: %s", conf.getName()));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using settings: " + conf.getSettings()));
            }
            this.getClient().admin().indices().prepareCreate(conf.getName()).setSettings(conf.getSettings()).execute().actionGet();
        }
        if (!mappingExists) {
            log.info((Object)String.format("Creating mapping type: %s on index: %s", conf.getType(), conf.getName()));
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using mapping: " + conf.getMapping()));
            }
            this.getClient().admin().indices().preparePutMapping(new String[]{conf.getName()}).setType(conf.getType()).setSource(conf.getMapping()).execute().actionGet();
            if (!dropIfExists && conf.getRepositoryName() != null) {
                this.repositoryInitialized.add(conf.getRepositoryName());
            }
        }
        this.checkClusterHealth(conf.getName());
    }

    public int getPendingWorkerCount() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public int getRunningWorkerCount() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public int getTotalCommandProcessed() {
        return this.totalCommandProcessed.get();
    }

    public boolean isEmbedded() {
        return this.embedded;
    }

    public boolean useExternalVersion() {
        if (this.isEmbedded()) {
            return this.localConfig.useExternalVersion();
        }
        return this.remoteConfig.useExternalVersion();
    }

    public boolean isIndexingInProgress() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public ListenableFuture<Boolean> prepareWaitForIndexing() {
        throw new UnsupportedOperationException("Not implemented");
    }

    public String[] getSearchIndexes(List<String> searchRepositories) {
        if (searchRepositories.isEmpty()) {
            Collection<String> values = this.indexNames.values();
            return values.toArray(new String[values.size()]);
        }
        ArrayList<String> indices = new ArrayList<String>(searchRepositories.size());
        for (String repo : searchRepositories) {
            try {
                if (ReIndexingRunnerManager.get().isReIndexingInProgress(repo)) {
                    for (String idx : this.getReadIndicesForReIndexingRepository(repo)) {
                        indices.add(idx);
                    }
                    continue;
                }
                indices.add(this.getConfiguredIndexOrAliasNameForRepository(repo));
            }
            catch (InterruptedException e) {
                if (!log.isErrorEnabled()) continue;
                log.error((Object)e);
            }
        }
        return indices.toArray(new String[indices.size()]);
    }

    public String[] getReadIndicesForReIndexingRepository(String repositoryName) {
        String[] res = null;
        List<String> transientReadIndices = IndexNAliasManager.get().getIndicesOfAlias(TransitoryIndexUse.Read.getAlias());
        if (transientReadIndices != null) {
            res = new String[]{};
            res = transientReadIndices.toArray(res);
        }
        return res;
    }

    public String getIndexNameForRepository(String repositoryName) {
        String writeIndexOrAlias;
        block3: {
            writeIndexOrAlias = null;
            try {
                writeIndexOrAlias = ReIndexingRunnerManager.get().isReIndexingInProgress(repositoryName) ? TransitoryIndexUse.Write.getAlias() : this.getConfiguredIndexOrAliasNameForRepository(repositoryName);
                if (log.isTraceEnabled()) {
                    log.trace((Object)String.format("Write alias: [%s]", writeIndexOrAlias));
                }
            }
            catch (InterruptedException e) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)e);
            }
        }
        return writeIndexOrAlias;
    }

    @Override
    public String getConfiguredIndexOrAliasNameForRepository(String repositoryName) {
        String ret = this.indexNames.get(repositoryName);
        if (ret == null) {
            throw new NoSuchElementException("No index or alias defined for repository: " + repositoryName);
        }
        return ret;
    }

    private boolean aliasConfigured(String repositoryName) {
        ElasticSearchIndexConfig esCfg = this.getIndexConfig().get(this.getIndexNames().get(repositoryName));
        return esCfg instanceof OttcElasticSearchIndexOrAliasConfig && ((OttcElasticSearchIndexOrAliasConfig)esCfg).aliasConfigured();
    }

    @Override
    public boolean isZeroDownTimeReIndexingInProgress(String repository) throws InterruptedException {
        return ReIndexingRunnerManager.get().isReIndexingInProgress(repository);
    }

    public Map<String, ElasticSearchIndexConfig> getIndexConfig() {
        return this.indexConfig;
    }

    @Override
    public Map<String, String> getIndexNames() {
        return this.indexNames;
    }

    @Override
    public Map<String, String> getRepoNames() {
        return this.repoNames;
    }

    public boolean isReady() {
        return this.indexInitDone;
    }

    String[] getIncludeSourceFields() {
        return this.includeSourceFields;
    }

    String[] getExcludeSourceFields() {
        return this.excludeSourceFields;
    }

    Map<String, String> getRepositoryMap() {
        return this.repoNames;
    }

    public List<String> getInitializedRepositories() {
        return this.repositoryInitialized;
    }
}

