/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.task.core.service;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.UnrestrictedSessionRunner;
import org.nuxeo.ecm.core.api.security.ACE;
import org.nuxeo.ecm.core.api.security.ACL;
import org.nuxeo.ecm.core.api.security.ACP;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.ecm.platform.task.TaskService;

public class CreateTaskUnrestricted
extends UnrestrictedSessionRunner {
    private NuxeoPrincipal principal;
    private DocumentModel document;
    private String taskName;
    private String taskType;
    private String processId;
    private String taskDocumentType;
    private List<String> prefixedActorIds;
    private boolean createOneTaskPerActor;
    private String directive;
    private String comment;
    private Date dueDate;
    private Map<String, String> taskVariables;
    private String parentPath;
    List<Task> tasks = new ArrayList<Task>();
    protected List<DocumentModel> documents;

    public CreateTaskUnrestricted(CoreSession session, NuxeoPrincipal principal, DocumentModel document, String taskName, List<String> prefixedActorIds, boolean createOneTaskPerActor, String directive, String comment, Date dueDate, Map<String, String> taskVariables, String parentPath) {
        this(session, principal, document, taskName, null, null, prefixedActorIds, createOneTaskPerActor, directive, comment, dueDate, taskVariables, parentPath);
    }

    public CreateTaskUnrestricted(CoreSession session, NuxeoPrincipal principal, DocumentModel document, String taskName, String taskType, String processId, List<String> prefixedActorIds, boolean createOneTaskPerActor, String directive, String comment, Date dueDate, Map<String, String> taskVariables, String parentPath) {
        super(session);
        this.principal = principal;
        this.document = document;
        this.taskName = taskName;
        this.taskType = taskType;
        this.processId = processId;
        this.prefixedActorIds = prefixedActorIds;
        this.createOneTaskPerActor = createOneTaskPerActor;
        this.directive = directive;
        this.comment = comment;
        this.dueDate = dueDate;
        this.taskVariables = taskVariables;
        this.parentPath = parentPath;
        this.documents = new ArrayList<DocumentModel>();
        this.documents.add(document);
    }

    public CreateTaskUnrestricted(CoreSession session, NuxeoPrincipal principal, DocumentModel document, String taskDocumentType, String taskName, String taskType, String processId, List<String> prefixedActorIds, boolean createOneTaskPerActor, String directive, String comment, Date dueDate, Map<String, String> taskVariables, String parentPath) {
        this(session, principal, document, taskName, taskType, processId, prefixedActorIds, createOneTaskPerActor, directive, comment, dueDate, taskVariables, parentPath);
        this.taskDocumentType = taskDocumentType;
    }

    public CreateTaskUnrestricted(CoreSession session, NuxeoPrincipal principal, List<DocumentModel> documents, String taskDocumentType, String taskName, String taskType, String processId, List<String> prefixedActorIds, boolean createOneTaskPerActor, String directive, String comment, Date dueDate, Map<String, String> taskVariables, String parentPath) {
        this(session, principal, documents != null && documents.size() > 0 ? documents.get(0) : null, taskName, taskType, processId, prefixedActorIds, createOneTaskPerActor, directive, comment, dueDate, taskVariables, parentPath);
        this.taskDocumentType = taskDocumentType;
        this.documents = documents;
        if (this.documents != null && this.documents.size() > 0) {
            this.document = documents.get(0);
        }
    }

    public void run() throws ClientException {
        if (StringUtils.isEmpty((String)this.taskDocumentType)) {
            this.taskDocumentType = "TaskDoc";
        }
        this.createTask(this.session, this.principal, this.documents, this.taskDocumentType, this.taskName, this.taskType, this.processId, this.prefixedActorIds, this.createOneTaskPerActor, this.directive, this.comment, this.dueDate, this.taskVariables, this.parentPath);
    }

    public void createTask(CoreSession coreSession, NuxeoPrincipal principal, DocumentModel document, String taskDocumentType, String taskName, String taskType, String processId, List<String> prefixedActorIds, boolean createOneTaskPerActor, String directive, String comment, Date dueDate, Map<String, String> taskVariables, String parentPath) throws ClientException {
        ArrayList<DocumentModel> docs = new ArrayList<DocumentModel>();
        docs.add(document);
        this.createTask(coreSession, principal, docs, taskDocumentType, taskName, taskType, processId, prefixedActorIds, createOneTaskPerActor, directive, comment, dueDate, taskVariables, parentPath);
    }

    public void createTask(CoreSession coreSession, NuxeoPrincipal principal, List<DocumentModel> documents, String taskDocumentType, String taskName, String taskType, String processId, List<String> prefixedActorIds, boolean createOneTaskPerActor, String directive, String comment, Date dueDate, Map<String, String> taskVariables, String parentPath) throws ClientException {
        if (createOneTaskPerActor) {
            for (String prefixedActorId : prefixedActorIds) {
                this.createTask(coreSession, principal, documents, taskDocumentType, taskName, taskType, processId, Collections.singletonList(prefixedActorId), false, directive, comment, dueDate, taskVariables, parentPath);
            }
        } else {
            try {
                String docName = taskType == null ? taskName : taskType;
                DocumentModel taskDocument = this.session.createDocumentModel(parentPath, docName, taskDocumentType);
                Task task = (Task)taskDocument.getAdapter(Task.class);
                if (task == null) {
                    throw new ClientRuntimeException("Document " + taskDocumentType + "  can not be adapted to a Task");
                }
                task.setName(taskName);
                task.setType(taskType);
                task.setProcessId(processId);
                task.setCreated(new Date());
                if (principal != null) {
                    String username = principal.getActingUser();
                    task.setInitiator(username);
                }
                task.setActors(prefixedActorIds);
                task.setDueDate(dueDate);
                if (documents != null) {
                    ArrayList<String> docIds = new ArrayList<String>();
                    for (DocumentModel documentModel : documents) {
                        docIds.add(documentModel.getId());
                    }
                    task.setTargetDocumentsIds(docIds);
                }
                task.setDirective(directive);
                if (!StringUtils.isEmpty((String)comment)) {
                    task.addComment(principal.getName(), comment);
                }
                HashMap<String, String> variables = new HashMap<String, String>();
                if (this.document != null) {
                    variables.put(TaskService.VariableName.documentId.name(), this.document.getId());
                    variables.put(TaskService.VariableName.documentRepositoryName.name(), this.document.getRepositoryName());
                }
                variables.put(TaskService.VariableName.directive.name(), directive);
                variables.put(TaskService.VariableName.createdFromTaskService.name(), "true");
                if (taskVariables != null) {
                    variables.putAll(taskVariables);
                }
                task.setVariables(variables);
                taskDocument = this.session.createDocument(taskDocument);
                task = (Task)taskDocument.getAdapter(Task.class);
                ArrayList<String> actorIds = new ArrayList<String>();
                for (String actor : prefixedActorIds) {
                    if (actor.startsWith("group:") || actor.startsWith("user:")) {
                        actorIds.add(actor.substring(actor.indexOf(":") + 1));
                        continue;
                    }
                    actorIds.add(actor);
                }
                ACP aCP = taskDocument.getACP();
                ACL acl = aCP.getOrCreateACL("local");
                if (principal != null) {
                    acl.add((Object)new ACE(principal.getName(), "Everything", true));
                }
                for (String actorId : actorIds) {
                    acl.add((Object)new ACE(actorId, "Everything", true));
                }
                aCP.addACL(acl);
                taskDocument.setACP(aCP, true);
                taskDocument = this.session.saveDocument(taskDocument);
                this.tasks.add(task);
            }
            catch (ClientException e) {
                throw new ClientRuntimeException((Throwable)e);
            }
        }
    }

    public void createTask(CoreSession coreSession, NuxeoPrincipal principal, DocumentModel document, String taskName, List<String> prefixedActorIds, boolean createOneTaskPerActor, String directive, String comment, Date dueDate, Map<String, String> taskVariables, String parentPath) throws ClientException {
        this.createTask(coreSession, principal, document, "TaskDoc", taskName, null, null, prefixedActorIds, createOneTaskPerActor, directive, comment, dueDate, taskVariables, parentPath);
    }

    public List<Task> getTasks() {
        return this.tasks;
    }
}

