/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.platform.routing.core.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mvel2.CompileException;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.automation.core.scripting.DateWrapper;
import org.nuxeo.ecm.automation.core.scripting.Expression;
import org.nuxeo.ecm.automation.core.scripting.Scripting;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.ClientRuntimeException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.model.Property;
import org.nuxeo.ecm.core.api.model.impl.ListProperty;
import org.nuxeo.ecm.core.api.model.impl.MapProperty;
import org.nuxeo.ecm.core.schema.utils.DateParser;
import org.nuxeo.ecm.platform.routing.api.DocumentRoute;
import org.nuxeo.ecm.platform.routing.api.DocumentRoutingService;
import org.nuxeo.ecm.platform.routing.api.exception.DocumentRouteException;
import org.nuxeo.ecm.platform.routing.core.api.TasksInfoWrapper;
import org.nuxeo.ecm.platform.routing.core.api.scripting.RoutingScriptingExpression;
import org.nuxeo.ecm.platform.routing.core.api.scripting.RoutingScriptingFunctions;
import org.nuxeo.ecm.platform.routing.core.impl.DocumentRouteElementImpl;
import org.nuxeo.ecm.platform.routing.core.impl.GraphNode;
import org.nuxeo.ecm.platform.routing.core.impl.GraphRouteImpl;
import org.nuxeo.ecm.platform.routing.core.impl.GraphRunner;
import org.nuxeo.ecm.platform.routing.core.impl.GraphVariablesUtil;
import org.nuxeo.ecm.platform.task.Task;
import org.nuxeo.runtime.api.Framework;

public class GraphNodeImpl
extends DocumentRouteElementImpl
implements GraphNode {
    private static final long serialVersionUID = 1L;
    private static final Log log = LogFactory.getLog(GraphNodeImpl.class);
    private static final String EXPR_PREFIX = "expr:";
    private static final String TEMPLATE_START = "@{";
    protected final GraphRouteImpl graph;
    protected GraphNode.State localState;
    protected List<GraphNode.Transition> inputTransitions;
    protected List<GraphNode.Transition> outputTransitions;
    protected List<GraphNode.Button> taskButtons;
    protected List<GraphNode.EscalationRule> escalationRules;
    protected List<GraphNode.TaskInfo> tasksInfo;

    public GraphNodeImpl(DocumentModel doc, GraphRouteImpl graph) {
        super(doc, new GraphRunner());
        this.graph = graph;
        this.inputTransitions = new ArrayList<GraphNode.Transition>(2);
    }

    public GraphNodeImpl(DocumentModel doc) {
        super(doc, new GraphRunner());
        this.graph = (GraphRouteImpl)this.getDocumentRoute(doc.getCoreSession());
        this.inputTransitions = new ArrayList<GraphNode.Transition>(2);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append((Object)this.getId()).toString();
    }

    protected boolean getBoolean(String propertyName) {
        return Boolean.TRUE.equals(this.getProperty(propertyName));
    }

    protected void incrementProp(String prop) {
        try {
            Long count = (Long)this.getProperty(prop);
            if (count == null) {
                count = 0L;
            }
            this.document.setPropertyValue(prop, (Serializable)Long.valueOf(count + 1L));
            this.saveDocument();
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    protected CoreSession getSession() {
        return this.document.getCoreSession();
    }

    protected void saveDocument() throws ClientException {
        this.getSession().saveDocument(this.document);
    }

    @Override
    public String getId() {
        return (String)this.getProperty("rnode:nodeId");
    }

    @Override
    public GraphNode.State getState() {
        try {
            if (this.localState != null) {
                return this.localState;
            }
            String s = this.document.getCurrentLifeCycleState();
            return GraphNode.State.fromString(s);
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Override
    public void setState(GraphNode.State state) {
        try {
            if (state == null) {
                throw new NullPointerException("null state");
            }
            String lc = state.getLifeCycleState();
            if (lc == null) {
                this.localState = state;
                return;
            }
            this.localState = null;
            String oldLc = this.document.getCurrentLifeCycleState();
            if (lc.equals(oldLc)) {
                return;
            }
            this.document.followTransition(state.getTransition());
            this.saveDocument();
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Override
    public boolean isStart() {
        return this.getBoolean("rnode:start");
    }

    @Override
    public boolean isStop() {
        return this.getBoolean("rnode:stop");
    }

    @Override
    public void setCanceled() {
        log.debug((Object)("Canceling " + this));
        this.incrementProp("rnode:canceled");
    }

    @Override
    public long getCanceledCount() {
        Long c = (Long)this.getProperty("rnode:canceled");
        return c == null ? 0L : c;
    }

    @Override
    public boolean isMerge() {
        String merge = (String)this.getProperty("rnode:merge");
        return StringUtils.isNotEmpty((String)merge);
    }

    @Override
    public String getInputChain() {
        return (String)this.getProperty("rnode:inputChain");
    }

    @Override
    public String getOutputChain() {
        return (String)this.getProperty("rnode:outputChain");
    }

    @Override
    public boolean hasTask() {
        return this.getBoolean("rnode:hasTask");
    }

    @Override
    public List<String> getTaskAssignees() {
        return (List)this.getProperty("rnode:taskAssignees");
    }

    public String getTaskAssigneesVar() {
        return (String)this.getProperty("rnode:taskAssigneesExpr");
    }

    @Override
    public Date getTaskDueDate() {
        Calendar cal = (Calendar)this.getProperty("rnode:taskDueDate");
        return cal == null ? null : cal.getTime();
    }

    @Override
    public String getTaskDirective() {
        return (String)this.getProperty("rnode:taskDirective");
    }

    @Override
    public String getTaskAssigneesPermission() {
        return (String)this.getProperty("rnode:taskAssigneesPermission");
    }

    @Override
    public String getTaskLayout() {
        return (String)this.getProperty("rnode:taskLayout");
    }

    @Override
    public String getTaskNotificationTemplate() {
        return (String)this.getProperty("rnode:taskNotificationTemplate");
    }

    @Override
    public String getTaskDueDateExpr() {
        return (String)this.getProperty("rnode:taskDueDateExpr");
    }

    @Override
    public void starting() {
        try {
            for (GraphNode.Transition t : this.inputTransitions) {
                t.setResult(false);
                this.getSession().saveDocument(t.source.getDocument());
            }
            this.incrementProp("rnode:count");
            this.document.setPropertyValue("rnode:startDate", (Serializable)Calendar.getInstance());
            this.tasksInfo = null;
            this.document.setPropertyValue("rnode:tasksInfo", new ArrayList());
            this.saveDocument();
        }
        catch (Exception e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Override
    public void ending() {
        try {
            this.document.setPropertyValue("rnode:endDate", (Serializable)Calendar.getInstance());
            this.saveDocument();
        }
        catch (Exception e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Override
    public Map<String, Serializable> getVariables() {
        return GraphVariablesUtil.getVariables(this.document, "rnode:variablesFacet");
    }

    @Override
    public void setVariables(Map<String, Serializable> map) {
        if (map.containsKey("_MAP_VAR_FORMAT_JSON") && ((Boolean)map.get("_MAP_VAR_FORMAT_JSON")).booleanValue()) {
            HashMap<String, String> vars = new HashMap<String, String>();
            map.remove("_MAP_VAR_FORMAT_JSON");
            for (String key : map.keySet()) {
                if (map.get(key) != null && !(map.get(key) instanceof String)) {
                    throw new ClientRuntimeException("Trying to decode JSON variables: The parameter 'map' should contain only Strings as it contains the marker '_MAP_VAR_FORMAT_JSON' ");
                }
                vars.put(key, (String)((Object)map.get(key)));
            }
            GraphVariablesUtil.setJSONVariables(this.document, "rnode:variablesFacet", vars);
        } else {
            GraphVariablesUtil.setVariables(this.document, "rnode:variablesFacet", map);
        }
    }

    @Override
    public void setJSONVariables(Map<String, String> map) {
        GraphVariablesUtil.setJSONVariables(this.document, "rnode:variablesFacet", map);
    }

    @Override
    public void setAllVariables(Map<String, Object> map) {
        Serializable oldValue;
        Serializable value;
        String key;
        if (map == null) {
            return;
        }
        Boolean mapToJSON = Boolean.FALSE;
        if (map.containsKey("_MAP_VAR_FORMAT_JSON") && ((Boolean)map.get("_MAP_VAR_FORMAT_JSON")).booleanValue()) {
            mapToJSON = Boolean.TRUE;
        }
        Map<String, Serializable> graphVariables = this.graph.getVariables();
        Map<String, Serializable> nodeVariables = this.getVariables();
        boolean changedNodeVariables = false;
        boolean changedGraphVariables = false;
        if (map.get("NodeVariables") != null) {
            for (Map.Entry es : ((Map)map.get("NodeVariables")).entrySet()) {
                key = (String)es.getKey();
                value = (Serializable)es.getValue();
                if (!nodeVariables.containsKey(key) || GraphNodeImpl.equality(value, oldValue = nodeVariables.get(key))) continue;
                changedNodeVariables = true;
                nodeVariables.put(key, value);
            }
        }
        if (map.get("WorkflowVariables") != null) {
            for (Map.Entry es : ((Map)map.get("WorkflowVariables")).entrySet()) {
                key = (String)es.getKey();
                value = (Serializable)es.getValue();
                if (!graphVariables.containsKey(key) || GraphNodeImpl.equality(value, oldValue = graphVariables.get(key))) continue;
                changedGraphVariables = true;
                graphVariables.put(key, value);
            }
        }
        if (changedNodeVariables) {
            nodeVariables.put("_MAP_VAR_FORMAT_JSON", mapToJSON);
            this.setVariables(nodeVariables);
        }
        if (changedGraphVariables) {
            graphVariables.put("_MAP_VAR_FORMAT_JSON", mapToJSON);
            this.graph.setVariables(graphVariables);
        }
    }

    public static boolean equality(Object o1, Object o2) {
        if (o1 == o2) {
            return true;
        }
        if (o1 == null || o2 == null) {
            return false;
        }
        if (o1 instanceof List && o2.getClass().isArray()) {
            return Arrays.equals(((List)o1).toArray(), (Object[])o2);
        }
        if (o1.getClass().isArray() && o2 instanceof List) {
            return Arrays.equals((Object[])o1, ((List)o2).toArray());
        }
        if (o1.getClass().isArray() && o2.getClass().isArray()) {
            return Arrays.equals((Object[])o1, (Object[])o2);
        }
        return o1.equals(o2);
    }

    protected OperationContext getExecutionContext(CoreSession session) {
        OperationContext context = new OperationContext(session);
        context.putAll(this.getWorkflowContextualInfo(session, true));
        context.setCommit(false);
        DocumentModelList documents = this.graph.getAttachedDocuments(session);
        context.setInput((Object)documents);
        return context;
    }

    @Override
    public Map<String, Serializable> getWorkflowContextualInfo(CoreSession session, boolean detached) {
        HashMap<String, Serializable> context = new HashMap<String, Serializable>();
        context.put("WorkflowVariables", (Serializable)((Object)this.graph.getVariables()));
        context.put("workflowInitiator", (Serializable)((Object)this.getWorkflowInitiator()));
        context.put("workflowStartTime", this.getWorkflowStartTime());
        context.put("workflowParent", (Serializable)((Object)this.getWorkflowParentRouteId()));
        context.put("workflowParentNode", (Serializable)((Object)this.getWorkflowParentNodeId()));
        context.put("workflowInstanceId", (Serializable)((Object)this.graph.getDocument().getId()));
        context.put("taskDueTime", (Calendar)this.getProperty("rnode:taskDueDate"));
        DocumentModelList documents = this.graph.getAttachedDocuments(session);
        if (detached) {
            for (DocumentModel documentModel : documents) {
                try {
                    documentModel.detach(true);
                }
                catch (ClientException e) {
                    log.error((Object)e);
                    throw new ClientRuntimeException((Throwable)e);
                }
            }
        }
        context.put("workflowDocuments", (Serializable)documents);
        context.put("documents", (Serializable)documents);
        String button = (String)this.getProperty("rnode:button");
        Map<String, Serializable> nodeVariables = this.getVariables();
        nodeVariables.put("button", (Serializable)((Object)button));
        nodeVariables.put("numberOfProcessedTasks", Integer.valueOf(this.getProcessedTasksInfo().size()));
        nodeVariables.put("numberOfTasks", Integer.valueOf(this.getTasksInfo().size()));
        nodeVariables.put("tasks", new TasksInfoWrapper(this.getTasksInfo()));
        context.put("NodeVariables", (Serializable)((Object)nodeVariables));
        context.put("nodeId", (Serializable)((Object)this.getId()));
        String state = this.getState().name().toLowerCase();
        context.put("nodeState", (Serializable)((Object)state));
        context.put("state", (Serializable)((Object)state));
        context.put("nodeStartTime", this.getNodeStartTime());
        context.put("nodeEndTime", this.getNodeEndTime());
        context.put("nodeLastActor", (Serializable)((Object)this.getNodeLastActor()));
        context.put("comment", (Serializable)((Object)""));
        return context;
    }

    protected String getWorkflowInitiator() {
        try {
            return (String)((Object)this.graph.getDocument().getPropertyValue("docri:initiator"));
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    protected Calendar getWorkflowStartTime() {
        try {
            return (Calendar)this.graph.getDocument().getPropertyValue("dc:created");
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    protected String getWorkflowParentRouteId() {
        try {
            return (String)((Object)this.graph.getDocument().getPropertyValue("docri:parentRouteInstanceId"));
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    protected String getWorkflowParentNodeId() {
        try {
            return (String)((Object)this.graph.getDocument().getPropertyValue("docri:parentRouteNodeId"));
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    protected Calendar getNodeStartTime() {
        try {
            return (Calendar)this.getDocument().getPropertyValue("rnode:startDate");
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    protected Calendar getNodeEndTime() {
        try {
            return (Calendar)this.getDocument().getPropertyValue("rnode:endDate");
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    protected String getNodeLastActor() {
        try {
            return (String)((Object)this.getDocument().getPropertyValue("rnode:lastActor"));
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Override
    public void executeChain(String chainId) throws DocumentRouteException {
        this.executeChain(chainId, null);
    }

    @Override
    public void executeTransitionChain(GraphNode.Transition transition) throws DocumentRouteException {
        this.executeChain(transition.chain, transition.id);
    }

    public void executeChain(String chainId, String transitionId) throws DocumentRouteException {
        if (StringUtils.isEmpty((String)chainId)) {
            return;
        }
        OperationContext context = this.getExecutionContext(this.getSession());
        if (transitionId != null) {
            context.put("transition", (Object)transitionId);
        }
        AutomationService automationService = (AutomationService)Framework.getLocalService(AutomationService.class);
        try {
            automationService.run(context, chainId);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DocumentRouteException("Error running chain: " + chainId, (Throwable)e);
        }
        this.setAllVariables((Map<String, Object>)context);
    }

    @Override
    public void initAddInputTransition(GraphNode.Transition transition) {
        this.inputTransitions.add(transition);
    }

    protected List<GraphNode.Transition> computeOutputTransitions() {
        try {
            ListProperty props = (ListProperty)this.document.getProperty("rnode:transitions");
            ArrayList<GraphNode.Transition> trans = new ArrayList<GraphNode.Transition>(props.size());
            for (Property p : props) {
                trans.add(new GraphNode.Transition(this, p));
            }
            return trans;
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Override
    public List<GraphNode.Transition> getOutputTransitions() {
        if (this.outputTransitions == null) {
            this.outputTransitions = this.computeOutputTransitions();
        }
        return this.outputTransitions;
    }

    @Override
    public List<GraphNode.Transition> evaluateTransitions() throws DocumentRouteException {
        try {
            ArrayList<GraphNode.Transition> trueTrans = new ArrayList<GraphNode.Transition>();
            OperationContext context = this.getExecutionContext(this.getSession());
            for (GraphNode.Transition t : this.getOutputTransitions()) {
                context.put("transition", (Object)t.id);
                RoutingScriptingExpression expr = new RoutingScriptingExpression(t.condition, new RoutingScriptingFunctions(context));
                Object res = null;
                try {
                    res = expr.eval(context);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new DocumentRouteException("Error evaluating condition: " + t.condition, (Throwable)e);
                }
                if (!(res instanceof Boolean)) {
                    throw new DocumentRouteException("Condition for transition " + t + " of node '" + this.getId() + "' of graph '" + this.graph.getName() + "' does not evaluate to a boolean: " + t.condition);
                }
                boolean bool = Boolean.TRUE.equals(res);
                t.setResult(bool);
                if (!bool) continue;
                trueTrans.add(t);
                if (!this.executeOnlyFirstTransition()) continue;
                break;
            }
            this.saveDocument();
            return trueTrans;
        }
        catch (DocumentRouteException e) {
            throw e;
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Override
    public List<String> evaluateTaskAssignees() throws DocumentRouteException {
        ArrayList<String> taskAssignees = new ArrayList<String>();
        String taskAssigneesVar = this.getTaskAssigneesVar();
        if (StringUtils.isEmpty((String)taskAssigneesVar)) {
            return taskAssignees;
        }
        OperationContext context = this.getExecutionContext(this.getSession());
        Expression expr = Scripting.newExpression((String)taskAssigneesVar);
        Object[] res = null;
        try {
            res = expr.eval(context);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DocumentRouteException("Error evaluating task assignees: " + taskAssigneesVar, (Throwable)e);
        }
        if (res instanceof List) {
            res = ((List)res).toArray();
        }
        if (res instanceof Object[]) {
            Object[] list = res;
            String[] tmp = new String[list.length];
            try {
                System.arraycopy(list, 0, tmp, 0, list.length);
                res = tmp;
            }
            catch (ArrayStoreException arrayStoreException) {
                // empty catch block
            }
        }
        if (!(res instanceof String) && !(res instanceof String[])) {
            throw new DocumentRouteException("Can not evaluate task assignees from " + taskAssigneesVar);
        }
        if (res instanceof String) {
            taskAssignees.add((String)res);
        } else {
            taskAssignees.addAll(Arrays.asList((String[])res));
        }
        return taskAssignees;
    }

    @Override
    public boolean canMerge() {
        try {
            int n = 0;
            List<GraphNode.Transition> inputTransitions = this.getInputTransitions();
            for (GraphNode.Transition t : inputTransitions) {
                if (!t.result) continue;
                ++n;
            }
            String merge = (String)this.getProperty("rnode:merge");
            if ("one".equals(merge)) {
                return n > 0;
            }
            if ("all".equals(merge)) {
                return n == inputTransitions.size();
            }
            throw new ClientRuntimeException("Illegal merge mode '" + merge + "' for node " + this);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public List<GraphNode.Transition> getInputTransitions() {
        return this.inputTransitions;
    }

    @Override
    public void cancelTasks() {
        CoreSession session = this.getSession();
        try {
            List<GraphNode.TaskInfo> tasks = this.getTasksInfo();
            for (GraphNode.TaskInfo task : tasks) {
                if (task.isEnded()) continue;
                this.cancelTask(session, task.getTaskDocId());
            }
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Override
    public List<GraphNode.Button> getTaskButtons() {
        if (this.taskButtons == null) {
            this.taskButtons = this.computeTaskButtons();
        }
        return this.taskButtons;
    }

    protected List<GraphNode.Button> computeTaskButtons() {
        try {
            ListProperty props = (ListProperty)this.document.getProperty("rnode:taskButtons");
            ArrayList<GraphNode.Button> btns = new ArrayList<GraphNode.Button>(props.size());
            for (Property p : props) {
                btns.add(new GraphNode.Button(this, p));
            }
            Collections.sort(btns);
            return btns;
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Override
    public void setButton(String status) {
        try {
            this.document.setPropertyValue("rnode:button", (Serializable)((Object)status));
            this.saveDocument();
        }
        catch (Exception e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Override
    public void setLastActor(String actor) {
        try {
            this.document.setPropertyValue("rnode:lastActor", (Serializable)((Object)actor));
            this.saveDocument();
        }
        catch (Exception e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    protected void addTaskAssignees(List<String> taskAssignees) {
        List<String> allTasksAssignees = this.getTaskAssignees();
        allTasksAssignees.addAll(taskAssignees);
        try {
            this.document.setPropertyValue("rnode:taskAssignees", (Serializable)((Object)allTasksAssignees));
            this.saveDocument();
        }
        catch (Exception e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Override
    public String getTaskDocType() {
        String taskDocType = (String)this.getProperty("rnode:taskDocType");
        if (StringUtils.isEmpty((String)taskDocType)) {
            taskDocType = "TaskDoc";
        }
        return taskDocType;
    }

    protected Date evaluateDueDate() throws DocumentRouteException {
        String taskDueDateExpr = this.getTaskDueDateExpr();
        if (StringUtils.isEmpty((String)taskDueDateExpr)) {
            return new Date();
        }
        OperationContext context = this.getExecutionContext(this.getSession());
        Expression expr = Scripting.newExpression((String)taskDueDateExpr);
        Object res = null;
        try {
            res = expr.eval(context);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DocumentRouteException("Error evaluating task due date: " + taskDueDateExpr, (Throwable)e);
        }
        if (res instanceof DateWrapper) {
            return ((DateWrapper)res).getDate();
        }
        if (res instanceof Date) {
            return (Date)res;
        }
        if (res instanceof Calendar) {
            return ((Calendar)res).getTime();
        }
        if (res instanceof String) {
            return DateParser.parseW3CDateTime((String)((String)res));
        }
        throw new DocumentRouteException("The following expression can not be evaluated to a date: " + taskDueDateExpr);
    }

    @Override
    public Date computeTaskDueDate() throws DocumentRouteException {
        Date dueDate = this.evaluateDueDate();
        try {
            this.document.setPropertyValue("rnode:taskDueDate", (Serializable)dueDate);
            CoreSession session = this.document.getCoreSession();
            session.saveDocument(this.document);
        }
        catch (Exception e) {
            throw new ClientRuntimeException((Throwable)e);
        }
        return dueDate;
    }

    @Override
    public boolean executeOnlyFirstTransition() {
        return this.getBoolean("rnode:executeOnlyFirstTransition");
    }

    @Override
    public boolean hasSubRoute() throws DocumentRouteException {
        return this.getSubRouteModelId() != null;
    }

    @Override
    public String getSubRouteModelId() throws DocumentRouteException {
        String subRouteModelExpr = (String)this.getProperty("rnode:subRouteModelExpr");
        if (StringUtils.isBlank((String)subRouteModelExpr)) {
            return null;
        }
        OperationContext context = this.getExecutionContext(this.getSession());
        String res = this.valueOrExpression(String.class, subRouteModelExpr, context, "Sub-workflow id expression");
        return StringUtils.defaultIfBlank((String)res, null);
    }

    protected String getSubRouteInstanceId() {
        return (String)this.getProperty("rnode:subRouteInstanceId");
    }

    @Override
    public DocumentRoute startSubRoute() throws DocumentRouteException {
        String subRouteModelId = this.getSubRouteModelId();
        DocumentRoutingService service = (DocumentRoutingService)Framework.getLocalService(DocumentRoutingService.class);
        List<String> docs = this.graph.getAttachedDocuments();
        String subRouteInstanceId = service.createNewInstance(subRouteModelId, docs, this.getSession(), false);
        try {
            DocumentModel subRouteInstance = this.getSession().getDocument((DocumentRef)new IdRef(subRouteInstanceId));
            subRouteInstance.setPropertyValue("docri:parentRouteInstanceId", (Serializable)((Object)this.getDocument().getParentRef().toString()));
            subRouteInstance.setPropertyValue("docri:parentRouteNodeId", (Serializable)((Object)this.getDocument().getName()));
            subRouteInstance = this.getSession().saveDocument(subRouteInstance);
            this.document.setPropertyValue("rnode:subRouteInstanceId", (Serializable)((Object)subRouteInstanceId));
            this.saveDocument();
            Map<String, Serializable> map = this.getSubRouteInitialVariables();
            service.startInstance(subRouteInstanceId, docs, map, this.getSession());
            DocumentRoute subRoute = (DocumentRoute)subRouteInstance.getAdapter(DocumentRoute.class);
            return subRoute;
        }
        catch (ClientException e) {
            throw new DocumentRouteException((Throwable)e);
        }
    }

    protected Map<String, Serializable> getSubRouteInitialVariables() throws ClientException {
        ListProperty props = (ListProperty)this.document.getProperty("rnode:subRouteVariables");
        HashMap<String, Serializable> map = new HashMap<String, Serializable>();
        OperationContext context = null;
        for (Property p : props) {
            MapProperty prop = (MapProperty)p;
            String key = (String)((Object)prop.get("key").getValue());
            String v = (String)((Object)prop.get("value").getValue());
            if (context == null) {
                context = this.getExecutionContext(this.getSession());
            }
            Serializable value = this.valueOrExpression(Serializable.class, v, context, "Sub-workflow variable expression");
            map.put(key, value);
        }
        return map;
    }

    protected <T> T valueOrExpression(Class<T> klass, String v, OperationContext context, String kind) throws DocumentRouteException {
        if (!v.startsWith(EXPR_PREFIX)) {
            return (T)v;
        }
        Expression expr = (v = v.substring(EXPR_PREFIX.length()).trim()).contains(TEMPLATE_START) ? Scripting.newTemplate((String)v) : Scripting.newExpression((String)v);
        Object res = null;
        try {
            res = expr.eval(context);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
        catch (CompileException e) {
            throw new DocumentRouteException("Error evaluating expression: " + v, (Throwable)e);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DocumentRouteException("Error evaluating expression: " + v, (Throwable)e);
        }
        if (!klass.isAssignableFrom(res.getClass())) {
            throw new DocumentRouteException(kind + " of node '" + this.getId() + "' of graph '" + this.graph.getName() + "' does not evaluate to " + klass.getSimpleName() + " but " + res.getClass().getName() + ": " + v);
        }
        return (T)res;
    }

    @Override
    public void cancelSubRoute() throws DocumentRouteException {
        String subRouteInstanceId = this.getSubRouteInstanceId();
        if (!StringUtils.isEmpty((String)subRouteInstanceId)) {
            try {
                DocumentModel subRouteDoc = this.getSession().getDocument((DocumentRef)new IdRef(subRouteInstanceId));
                DocumentRoute subRoute = (DocumentRoute)subRouteDoc.getAdapter(DocumentRoute.class);
                subRoute.cancel(this.getSession());
            }
            catch (ClientException e) {
                throw new DocumentRouteException((Throwable)e);
            }
        }
    }

    protected List<GraphNode.EscalationRule> computeEscalationRules() {
        try {
            ListProperty props = (ListProperty)this.document.getProperty("rnode:escalationRules");
            ArrayList<GraphNode.EscalationRule> rules = new ArrayList<GraphNode.EscalationRule>(props.size());
            for (Property p : props) {
                rules.add(new GraphNode.EscalationRule(this, p));
            }
            Collections.sort(rules);
            return rules;
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Override
    public List<GraphNode.EscalationRule> getEscalationRules() {
        if (this.escalationRules == null) {
            this.escalationRules = this.computeEscalationRules();
        }
        return this.escalationRules;
    }

    @Override
    public List<GraphNode.EscalationRule> evaluateEscalationRules() {
        try {
            ArrayList<GraphNode.EscalationRule> rulesToExecute = new ArrayList<GraphNode.EscalationRule>();
            OperationContext context = this.getExecutionContext(this.getSession());
            for (GraphNode.EscalationRule rule : this.getEscalationRules()) {
                RoutingScriptingExpression expr = new RoutingScriptingExpression(rule.condition, new RoutingScriptingFunctions(context, rule));
                Object res = null;
                try {
                    res = expr.eval(context);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (RuntimeException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new DocumentRouteException("Error evaluating condition: " + rule.condition, (Throwable)e);
                }
                if (!(res instanceof Boolean)) {
                    throw new DocumentRouteException("Condition for rule " + rule + " of node '" + this.getId() + "' of graph '" + this.graph.getName() + "' does not evaluate to a boolean: " + rule.condition);
                }
                boolean bool = Boolean.TRUE.equals(res);
                if (rule.isExecuted() && !rule.isMultipleExecution() || !bool) continue;
                rulesToExecute.add(rule);
            }
            this.saveDocument();
            return rulesToExecute;
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Override
    public boolean hasMultipleTasks() {
        return this.getBoolean("rnode:hasMultipleTasks");
    }

    protected List<GraphNode.TaskInfo> computeTasksInfo() {
        try {
            ListProperty props = (ListProperty)this.document.getProperty("rnode:tasksInfo");
            ArrayList<GraphNode.TaskInfo> tasks = new ArrayList<GraphNode.TaskInfo>(props.size());
            for (Property p : props) {
                tasks.add(new GraphNode.TaskInfo((GraphNode)this, p));
            }
            return tasks;
        }
        catch (ClientException e) {
            throw new ClientRuntimeException((Throwable)e);
        }
    }

    @Override
    public List<GraphNode.TaskInfo> getTasksInfo() {
        if (this.tasksInfo == null) {
            this.tasksInfo = this.computeTasksInfo();
        }
        return this.tasksInfo;
    }

    @Override
    public void addTaskInfo(String taskId) throws ClientException {
        this.getTasksInfo().add(new GraphNode.TaskInfo((GraphNode)this, taskId));
        this.saveDocument();
    }

    @Override
    public void removeTaskInfo(String taskId) throws ClientException {
        ListProperty props = (ListProperty)this.document.getProperty("rnode:tasksInfo");
        Property propertytoBeRemoved = null;
        for (Property p : props) {
            if (!taskId.equals(p.get("taskDocId").getValue())) continue;
            propertytoBeRemoved = p;
            break;
        }
        if (propertytoBeRemoved != null) {
            props.remove(propertytoBeRemoved);
            this.saveDocument();
            this.tasksInfo = null;
        }
    }

    @Override
    public void updateTaskInfo(String taskId, boolean ended, String status, String actor, String comment) throws ClientException {
        boolean updated = false;
        List<GraphNode.TaskInfo> tasksInfo = this.getTasksInfo();
        for (GraphNode.TaskInfo taskInfo : tasksInfo) {
            if (!taskId.equals(taskInfo.getTaskDocId())) continue;
            taskInfo.setComment(comment);
            taskInfo.setStatus(status);
            taskInfo.setActor(actor);
            taskInfo.setEnded(true);
            updated = true;
        }
        if (!updated) {
            GraphNode.TaskInfo ti = new GraphNode.TaskInfo((GraphNode)this, taskId);
            ti.setActor(actor);
            ti.setStatus(status);
            ti.setComment(comment);
            ti.setEnded(true);
            this.getTasksInfo().add(ti);
        }
        this.saveDocument();
    }

    @Override
    public List<GraphNode.TaskInfo> getEndedTasksInfo() {
        List<GraphNode.TaskInfo> tasksInfo = this.getTasksInfo();
        ArrayList<GraphNode.TaskInfo> endedTasks = new ArrayList<GraphNode.TaskInfo>();
        for (GraphNode.TaskInfo taskInfo : tasksInfo) {
            if (!taskInfo.isEnded()) continue;
            endedTasks.add(taskInfo);
        }
        return endedTasks;
    }

    @Override
    public boolean hasOpenTasks() {
        return this.getTasksInfo().size() != this.getEndedTasksInfo().size();
    }

    @Override
    public List<GraphNode.TaskInfo> getProcessedTasksInfo() {
        List<GraphNode.TaskInfo> tasksInfo = this.getTasksInfo();
        ArrayList<GraphNode.TaskInfo> processedTasks = new ArrayList<GraphNode.TaskInfo>();
        for (GraphNode.TaskInfo taskInfo : tasksInfo) {
            if (!taskInfo.isEnded() || taskInfo.getStatus() == null) continue;
            processedTasks.add(taskInfo);
        }
        return processedTasks;
    }

    @Override
    public boolean allowTaskReassignment() {
        return this.getBoolean("rnode:allowTaskReassignment");
    }

    protected void cancelTask(CoreSession session, String taskId) throws DocumentRouteException {
        try {
            IdRef taskRef = new IdRef(taskId);
            if (!session.exists((DocumentRef)taskRef)) {
                log.info((Object)String.format("Task with id %s does not exist anymore", taskId));
                DocumentModelList docs = this.graph.getAttachedDocumentModels();
                ((DocumentRoutingService)Framework.getLocalService(DocumentRoutingService.class)).removePermissionsForTaskActors(session, (List)docs, taskId);
                NuxeoPrincipal principal = (NuxeoPrincipal)session.getPrincipal();
                String actor = principal.getActingUser();
                this.updateTaskInfo(taskId, true, null, actor, null);
                return;
            }
            DocumentModel taskDoc = session.getDocument((DocumentRef)new IdRef(taskId));
            Task task = (Task)taskDoc.getAdapter(Task.class);
            if (task == null) {
                throw new DocumentRouteException("Invalid taskId: " + taskId);
            }
            DocumentModelList docs = this.graph.getAttachedDocumentModels();
            ((DocumentRoutingService)Framework.getLocalService(DocumentRoutingService.class)).removePermissionsForTaskActors(session, (List)docs, task);
            if (task.isOpened().booleanValue()) {
                task.cancel(session);
            }
            session.saveDocument(task.getDocument());
            NuxeoPrincipal principal = (NuxeoPrincipal)session.getPrincipal();
            String actor = principal.getActingUser();
            this.updateTaskInfo(taskId, true, null, actor, null);
        }
        catch (ClientException e) {
            throw new DocumentRouteException("Cannot cancel task", (Throwable)e);
        }
    }

    @Override
    public void setVariable(String name, String value) {
        Map<String, Serializable> nodeVariables = this.getVariables();
        if (nodeVariables.containsKey(name)) {
            nodeVariables.put(name, (Serializable)((Object)value));
            this.setVariables(nodeVariables);
        }
    }
}

