/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.theme.styling.service.registries;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.nuxeo.runtime.model.ContributionFragmentRegistry;
import org.nuxeo.theme.styling.service.descriptors.ThemePage;

public class PageRegistry
extends ContributionFragmentRegistry<ThemePage> {
    protected Map<String, ThemePage> themePageResources = new LinkedHashMap<String, ThemePage>();

    public String getContributionId(ThemePage contrib) {
        return contrib.getName();
    }

    public void contributionUpdated(String id, ThemePage contrib, ThemePage newOrigContrib) {
        this.themePageResources.put(id, contrib);
    }

    public void contributionRemoved(String id, ThemePage origContrib) {
        this.themePageResources.remove(id);
    }

    public ThemePage clone(ThemePage orig) {
        ThemePage clone = new ThemePage();
        clone.setName(orig.getName());
        clone.setDefaultFlavor(orig.getDefaultFlavor());
        clone.setAppendStyles(orig.getAppendStyles());
        List<String> styles = orig.getStyles();
        if (styles != null) {
            clone.setStyles(new ArrayList<String>(styles));
        }
        clone.setAppendFlavors(orig.getAppendFlavors());
        List<String> flavors = orig.getFlavors();
        if (flavors != null) {
            clone.setFlavors(new ArrayList<String>(flavors));
        }
        clone.setAppendResources(orig.getAppendResources());
        List<String> resources = orig.getResources();
        if (resources != null) {
            clone.setResources(new ArrayList<String>(resources));
        }
        clone.setLoaded(orig.isLoaded());
        return clone;
    }

    public void merge(ThemePage src, ThemePage dst) {
        List<String> newResources;
        List<String> newFlavors;
        List<String> newStyles;
        String newFlavor = src.getDefaultFlavor();
        if (newFlavor != null) {
            dst.setDefaultFlavor(newFlavor);
        }
        if ((newStyles = src.getStyles()) != null) {
            List<String> oldStyles;
            boolean keepOld;
            ArrayList<String> merged = new ArrayList<String>();
            merged.addAll(newStyles);
            boolean bl = keepOld = src.getAppendStyles() || newStyles.isEmpty() && !src.getAppendStyles();
            if (keepOld && (oldStyles = dst.getStyles()) != null) {
                merged.addAll(0, oldStyles);
            }
            dst.setStyles(merged);
        }
        if ((newFlavors = src.getFlavors()) != null) {
            List<String> oldFlavors;
            boolean keepOld;
            ArrayList<String> merged = new ArrayList<String>();
            merged.addAll(newFlavors);
            boolean bl = keepOld = src.getAppendFlavors() || newFlavors.isEmpty() && !src.getAppendFlavors();
            if (keepOld && (oldFlavors = dst.getFlavors()) != null) {
                merged.addAll(0, oldFlavors);
            }
            dst.setFlavors(merged);
        }
        if ((newResources = src.getResources()) != null) {
            List<String> oldResources;
            boolean keepOld;
            ArrayList<String> merged = new ArrayList<String>();
            merged.addAll(newResources);
            boolean bl = keepOld = src.getAppendResources() || newResources.isEmpty() && !src.getAppendResources();
            if (keepOld && (oldResources = dst.getResources()) != null) {
                merged.addAll(0, oldResources);
            }
            dst.setResources(merged);
        }
    }

    public ThemePage getThemePage(String id) {
        return this.themePageResources.get(id);
    }

    public List<ThemePage> getThemePages() {
        ArrayList<ThemePage> res = new ArrayList<ThemePage>();
        for (ThemePage page : this.themePageResources.values()) {
            if (page == null) continue;
            res.add(page);
        }
        return res;
    }

    public ThemePage getConfigurationApplyingToAllThemes() {
        return this.themePageResources.get("*");
    }
}

