/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.management.works;

import java.util.ArrayList;
import org.nuxeo.ecm.core.management.works.WorksQueueMonitoringMBean;
import org.nuxeo.ecm.core.work.api.Work;
import org.nuxeo.ecm.core.work.api.WorkManager;
import org.nuxeo.runtime.api.Framework;

public class WorksQueueMonitoring
implements WorksQueueMonitoringMBean {
    protected final String queueId;

    public WorksQueueMonitoring(String id) {
        this.queueId = id;
    }

    protected WorkManager manager() {
        return (WorkManager)Framework.getLocalService(WorkManager.class);
    }

    @Override
    public int getScheduledCount() {
        return this.manager().getQueueSize(this.queueId, Work.State.SCHEDULED);
    }

    @Override
    public int getRunningCount() {
        return this.manager().getQueueSize(this.queueId, Work.State.RUNNING);
    }

    @Override
    public int getCompletedCount() {
        return this.manager().getQueueSize(this.queueId, Work.State.COMPLETED);
    }

    @Override
    public String[] getScheduledWorks() {
        return this.listWorks(Work.State.SCHEDULED);
    }

    @Override
    public String[] getRunningWorks() {
        return this.listWorks(Work.State.RUNNING);
    }

    protected String[] listWorks(Work.State state) {
        ArrayList<String> works = new ArrayList<String>();
        for (Work work : this.manager().listWork(this.queueId, state)) {
            works.add(work.toString());
        }
        return works.toArray(new String[works.size()]);
    }
}

